# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from pydantic import BaseModel, ConfigDict, Field
from typing import Literal
from . import postal_address


class LineItem(BaseModel):
  model_config = ConfigDict(
    extra="allow",
  )
  id: str
  """
    Line item ID reference.
    """
  quantity: int = Field(..., ge=1)
  """
    Quantity of this item in this expectation.
    """


class Expectation(BaseModel):
  """Buyer-facing fulfillment expectation representing logical groupings of items (e.g., 'package'). Can be split, merged, or adjusted post-order to set buyer expectations for when/how items arrive."""

  model_config = ConfigDict(
    extra="allow",
  )
  id: str
  """
    Expectation identifier.
    """
  line_items: list[LineItem]
  """
    Which line items and quantities are in this expectation.
    """
  method_type: Literal["shipping", "pickup", "digital"]
  """
    Delivery method type (shipping, pickup, digital).
    """
  destination: postal_address.PostalAddress
  """
    Delivery destination address.
    """
  description: str | None = None
  """
    Human-readable delivery description (e.g., 'Arrives in 5-8 business days').
    """
  fulfillable_on: str | None = None
  """
    When this expectation can be fulfilled: 'now' or ISO 8601 timestamp for future date (backorder, pre-order).
    """
