# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Literal
from pydantic import BaseModel, ConfigDict


class FulfillmentAvailableMethodResponse(BaseModel):
  """Inventory availability hint for a fulfillment method type."""

  model_config = ConfigDict(
    extra="allow",
  )
  type: Literal["shipping", "pickup"]
  """
    Fulfillment method type this availability applies to.
    """
  line_item_ids: list[str]
  """
    Line items available for this fulfillment method.
    """
  fulfillable_on: str | None = None
  """
    'now' for immediate availability, or ISO 8601 date for future (preorders, transfers).
    """
  description: str | None = None
  """
    Human-readable availability info (e.g., 'Available for pickup at Downtown Store today').
    """
