# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from pydantic import BaseModel, ConfigDict
from . import fulfillment_option_resp


class FulfillmentGroupResponse(BaseModel):
  """A merchant-generated package/group of line items with fulfillment options."""

  model_config = ConfigDict(
    extra="allow",
  )
  id: str
  """
    Group identifier for referencing merchant-generated groups in updates.
    """
  line_item_ids: list[str]
  """
    Line item IDs included in this group/package.
    """
  options: list[fulfillment_option_resp.FulfillmentOptionResponse] | None = None
  """
    Available fulfillment options for this group.
    """
  selected_option_id: str | None = None
  """
    ID of the selected fulfillment option for this group.
    """
