# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from pydantic import AwareDatetime, BaseModel, ConfigDict
from . import total_resp


class FulfillmentOptionResponse(BaseModel):
  """A fulfillment option within a group (e.g., Standard Shipping $5, Express $15)."""

  model_config = ConfigDict(
    extra="allow",
  )
  id: str
  """
    Unique fulfillment option identifier.
    """
  title: str
  """
    Short label (e.g., 'Express Shipping', 'Curbside Pickup').
    """
  description: str | None = None
  """
    Complete context for buyer decision (e.g., 'Arrives Dec 12-15 via FedEx').
    """
  carrier: str | None = None
  """
    Carrier name (for shipping).
    """
  earliest_fulfillment_time: AwareDatetime | None = None
  """
    Earliest fulfillment date.
    """
  latest_fulfillment_time: AwareDatetime | None = None
  """
    Latest fulfillment date.
    """
  totals: list[total_resp.TotalResponse]
  """
    Fulfillment option totals breakdown.
    """
