# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from pydantic import BaseModel, ConfigDict
from typing import Literal


class AllowsMultiDestination(BaseModel):
  """Permits multiple destinations per method type."""

  model_config = ConfigDict(
    extra="allow",
  )
  shipping: bool | None = None
  """
    Multiple shipping destinations allowed.
    """
  pickup: bool | None = None
  """
    Multiple pickup locations allowed.
    """


class MerchantFulfillmentConfig(BaseModel):
  """Merchant's fulfillment configuration."""

  model_config = ConfigDict(
    extra="allow",
  )
  allows_multi_destination: AllowsMultiDestination | None = None
  """
    Permits multiple destinations per method type.
    """
  allows_method_combinations: (
    list[list[Literal["shipping", "pickup"]]] | None
  ) = None
  """
    Allowed method type combinations.
    """
