# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Literal
from pydantic import BaseModel, ConfigDict


class MessageError(BaseModel):
  model_config = ConfigDict(
    extra="allow",
  )
  type: Literal["error"]
  """
    Message type discriminator.
    """
  code: str
  """
    Error code. Possible values include: missing, invalid, out_of_stock, payment_declined, requires_sign_in, requires_3ds, requires_identity_linking. Freeform codes also allowed.
    """
  path: str | None = None
  """
    RFC 9535 JSONPath to the component the message refers to (e.g., $.items[1]).
    """
  content_type: Literal["plain", "markdown"] | None = "plain"
  """
    Content format, default = plain.
    """
  content: str
  """
    Human-readable message.
    """
  severity: Literal[
    "recoverable", "requires_buyer_input", "requires_buyer_review"
  ]
  """
    Declares who resolves this error. 'recoverable': agent can fix via API. 'requires_buyer_input': merchant requires information their API doesn't support collecting programmatically (checkout incomplete). 'requires_buyer_review': buyer must authorize before order placement due to policy, regulatory, or entitlement rules (checkout complete). Errors with 'requires_*' severity contribute to 'status: requires_escalation'.
    """
