# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Literal
from pydantic import BaseModel, ConfigDict


class MessageInfo(BaseModel):
  model_config = ConfigDict(
    extra="allow",
  )
  type: Literal["info"]
  """
    Message type discriminator.
    """
  path: str | None = None
  """
    RFC 9535 JSONPath to the component the message refers to.
    """
  code: str | None = None
  """
    Info code for programmatic handling.
    """
  content_type: Literal["plain", "markdown"] | None = "plain"
  """
    Content format, default = plain.
    """
  content: str
  """
    Human-readable message.
    """
