# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from pydantic import AnyUrl, BaseModel, ConfigDict
from typing import Any
from ...._internal import Version


class PaymentHandlerResponse(BaseModel):
  model_config = ConfigDict(
    extra="allow",
  )
  id: str
  """
    The unique identifier for this handler instance within the payment.handlers. Used by payment instruments to reference which handler produced them.
    """
  name: str
  """
    The specification name using reverse-DNS format. For example, dev.ucp.delegate_payment.
    """
  version: Version
  """
    Handler version in YYYY-MM-DD format.
    """
  spec: AnyUrl
  """
    A URI pointing to the technical specification or schema that defines how this handler operates.
    """
  config_schema: AnyUrl
  """
    A URI pointing to a JSON Schema used to validate the structure of the config object.
    """
  instrument_schemas: list[AnyUrl]
  config: dict[str, Any]
  """
    A dictionary containing provider-specific configuration details, such as merchant IDs, supported networks, or gateway credentials.
    """
