# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from pydantic import BaseModel, ConfigDict
from . import payment_credential, postal_address


class PaymentInstrumentBase(BaseModel):
  """The base definition for any payment instrument. It links the instrument to a specific Merchant configuration (handler_id) and defines common fields like billing address."""

  model_config = ConfigDict(
    extra="allow",
  )
  id: str
  """
    A unique identifier for this instrument instance, assigned by the Agent. Used to reference this specific instrument in the 'payment.selected_instrument_id' field.
    """
  handler_id: str
  """
    The unique identifier for the handler instance that produced this instrument. This corresponds to the 'id' field in the Payment Handler definition.
    """
  type: str
  """
    The broad category of the instrument (e.g., 'card', 'tokenized_card'). Specific schemas will constrain this to a constant value.
    """
  billing_address: postal_address.PostalAddress | None = None
  """
    The billing address associated with this payment method.
    """
  credential: payment_credential.PaymentCredential | None = None
