# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from pydantic import BaseModel, ConfigDict


class PostalAddress(BaseModel):
  model_config = ConfigDict(
    extra="allow",
  )
  extended_address: str | None = None
  """
    An address extension such as an apartment number, C/O or alternative name.
    """
  street_address: str | None = None
  """
    The street address.
    """
  address_locality: str | None = None
  """
    The locality in which the street address is, and which is in the region. For example, Mountain View.
    """
  address_region: str | None = None
  """
    The region in which the locality is, and which is in the country. Required for applicable countries (i.e. state in US, province in CA). For example, California or another appropriate first-level Administrative division.
    """
  address_country: str | None = None
  """
    The country. Recommended to be in 2-letter ISO 3166-1 alpha-2 format, for example "US". For backward compatibility, a 3-letter ISO 3166-1 alpha-3 country code such as "SGP" or a full country name such as "Singapore" can also be used.
    """
  postal_code: str | None = None
  """
    The postal code. For example, 94043.
    """
  first_name: str | None = None
  """
    Optional. First name of the contact associated with the address.
    """
  last_name: str | None = None
  """
    Optional. Last name of the contact associated with the address.
    """
  full_name: str | None = None
  """
    Optional. Full name of the contact associated with the address (if first_name or last_name fields are present they take precedence).
    """
  phone_number: str | None = None
  """
    Optional. Phone number of the contact associated with the address.
    """
