# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Literal
from pydantic import BaseModel, ConfigDict, Field


class TotalResponse(BaseModel):
  model_config = ConfigDict(
    extra="allow",
  )
  type: Literal[
    "items_discount",
    "subtotal",
    "discount",
    "fulfillment",
    "tax",
    "fee",
    "total",
  ]
  """
    Type of total categorization.
    """
  display_text: str | None = None
  """
    Text to display against the amount. Should reflect appropriate method (e.g., 'Shipping', 'Delivery').
    """
  amount: int = Field(..., ge=0)
  """
    If type == total, sums subtotal - discount + fulfillment + tax + fee. Should be >= 0. Amount in minor (cents) currency units.
    """
