# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Literal
from pydantic import BaseModel, ConfigDict
from ..schemas.shopping.types import payment_handler_resp
from .._internal import DiscoveryProfile


class SigningKey(BaseModel):
  model_config = ConfigDict(
    extra="allow",
  )
  kid: str
  """
    Key ID. Referenced in signature headers to identify which key to use for verification.
    """
  kty: str
  """
    Key type (e.g., 'EC', 'RSA').
    """
  crv: str | None = None
  """
    Curve name for EC keys (e.g., 'P-256').
    """
  x: str | None = None
  """
    X coordinate for EC public keys (base64url encoded).
    """
  y: str | None = None
  """
    Y coordinate for EC public keys (base64url encoded).
    """
  n: str | None = None
  """
    Modulus for RSA public keys (base64url encoded).
    """
  e: str | None = None
  """
    Exponent for RSA public keys (base64url encoded).
    """
  use: Literal["sig", "enc"] | None = None
  """
    Key usage. Should be 'sig' for signing keys.
    """
  alg: str | None = None
  """
    Algorithm (e.g., 'ES256', 'RS256').
    """


class Payment(BaseModel):
  """Payment configuration containing handlers."""

  model_config = ConfigDict(
    extra="allow",
  )
  handlers: list[payment_handler_resp.PaymentHandlerResponse] | None = None
  """
    Payment handler definitions that describe how instruments can be collected
    """


class UcpDiscoveryProfile(BaseModel):
  """Schema for UCP discovery profile returned from /.well-known/ucp."""

  model_config = ConfigDict(
    extra="allow",
  )
  ucp: DiscoveryProfile
  payment: Payment | None = None
  """
    Payment configuration containing handlers
    """
  signing_keys: list[SigningKey] | None = None
  """
    Public keys for signature verification (JWK format). Used to verify signed responses, webhooks, and other authenticated messages from this party.
    """
