# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from pydantic import BaseModel, ConfigDict
from .types import buyer as buyer_1, line_item_create_req
from . import payment_create_req


class CheckoutCreateRequest(BaseModel):
  """Base checkout schema. Extensions compose onto this using allOf."""

  model_config = ConfigDict(
    extra="allow",
  )
  line_items: list[line_item_create_req.LineItemCreateRequest]
  """
    List of line items being checked out.
    """
  buyer: buyer_1.Buyer | None = None
  """
    Representation of the buyer.
    """
  currency: str
  """
    ISO 4217 currency code.
    """
  payment: payment_create_req.PaymentCreateRequest
