# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Any, Literal
from pydantic import BaseModel, ConfigDict, Field, RootModel
from .checkout_resp import CheckoutResponse


class DiscountExtensionResponse(RootModel[Any]):
  root: Any = Field(..., title="Discount Extension Response")
  """
    Extends Checkout with discount code support, enabling agents to apply promotional, loyalty, referral, and other discount codes.
    """


class Allocation(BaseModel):
  """Breakdown of how a discount amount was allocated to a specific target."""

  model_config = ConfigDict(
    extra="allow",
  )
  path: str
  """
    JSONPath to the allocation target (e.g., '$.line_items[0]', '$.totals.shipping').
    """
  amount: int = Field(..., ge=0)
  """
    Amount allocated to this target in minor (cents) currency units.
    """


class AppliedDiscount(BaseModel):
  """A discount that was successfully applied."""

  model_config = ConfigDict(
    extra="allow",
  )
  code: str | None = None
  """
    The discount code. Omitted for automatic discounts.
    """
  title: str
  """
    Human-readable discount name (e.g., 'Summer Sale 20% Off').
    """
  amount: int = Field(..., ge=0)
  """
    Total discount amount in minor (cents) currency units.
    """
  automatic: bool | None = False
  """
    True if applied automatically by merchant rules (no code required).
    """
  method: Literal["each", "across"] | None = None
  """
    Allocation method. 'each' = applied independently per item. 'across' = split proportionally by value.
    """
  priority: int | None = Field(None, ge=1)
  """
    Stacking order for discount calculation. Lower numbers applied first (1 = first).
    """
  allocations: list[Allocation] | None = None
  """
    Breakdown of where this discount was allocated. Sum of allocation amounts equals total amount.
    """


class DiscountsObject(BaseModel):
  """Discount codes input and applied discounts output."""

  model_config = ConfigDict(
    extra="allow",
  )
  codes: list[str] | None = None
  """
    Discount codes to apply. Case-insensitive. Replaces previously submitted codes. Send empty array to clear.
    """
  applied: list[AppliedDiscount] | None = None
  """
    Discounts successfully applied (code-based and automatic).
    """


class Checkout(CheckoutResponse):
  """Checkout extended with discount capability."""

  model_config = ConfigDict(
    extra="allow",
  )
  discounts: DiscountsObject | None = None
