# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Any
from pydantic import ConfigDict, Field, RootModel
from .types import (
  fulfillment_available_method_req,
  fulfillment_group_update_req,
  fulfillment_method_update_req,
  fulfillment_option_req,
  fulfillment_req,
)
from .checkout_update_req import CheckoutUpdateRequest


class FulfillmentExtensionUpdateRequest(RootModel[Any]):
  root: Any = Field(..., title="Fulfillment Extension Update Request")
  """
    Extends Checkout with fulfillment support using methods, destinations, and groups.
    """


class FulfillmentOption(
  RootModel[fulfillment_option_req.FulfillmentOptionRequest]
):
  root: fulfillment_option_req.FulfillmentOptionRequest


class FulfillmentGroup(
  RootModel[fulfillment_group_update_req.FulfillmentGroupUpdateRequest]
):
  root: fulfillment_group_update_req.FulfillmentGroupUpdateRequest


class FulfillmentAvailableMethod(
  RootModel[fulfillment_available_method_req.FulfillmentAvailableMethodRequest]
):
  root: fulfillment_available_method_req.FulfillmentAvailableMethodRequest


class FulfillmentMethod(
  RootModel[fulfillment_method_update_req.FulfillmentMethodUpdateRequest]
):
  root: fulfillment_method_update_req.FulfillmentMethodUpdateRequest


class Fulfillment(RootModel[fulfillment_req.FulfillmentRequest]):
  root: fulfillment_req.FulfillmentRequest


class Checkout(CheckoutUpdateRequest):
  """Checkout extended with hierarchical fulfillment."""

  model_config = ConfigDict(
    extra="allow",
  )
  fulfillment: Fulfillment | None = None
  """
    Fulfillment details.
    """
