# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from pydantic import AnyUrl, BaseModel, ConfigDict
from .types import (
  adjustment,
  expectation,
  fulfillment_event,
  order_line_item,
  total_resp,
)
from ..._internal import ResponseOrder


class PlatformConfig(BaseModel):
  """Platform's order capability configuration."""

  model_config = ConfigDict(
    extra="allow",
  )
  webhook_url: AnyUrl
  """
    URL where merchant sends order lifecycle events (webhooks).
    """


class Fulfillment(BaseModel):
  """Fulfillment data: buyer expectations and what actually happened."""

  model_config = ConfigDict(
    extra="allow",
  )
  expectations: list[expectation.Expectation] | None = None
  """
    Buyer-facing groups representing when/how items will be delivered. Can be split, merged, or adjusted post-order.
    """
  events: list[fulfillment_event.FulfillmentEvent] | None = None
  """
    Append-only event log of actual shipments. Each event references line items by ID.
    """


class Order(BaseModel):
  """Order schema with immutable line items, buyer-facing fulfillment expectations, and append-only event logs."""

  model_config = ConfigDict(
    extra="allow",
  )
  ucp: ResponseOrder
  id: str
  """
    Unique order identifier.
    """
  checkout_id: str
  """
    Associated checkout ID for reconciliation.
    """
  permalink_url: AnyUrl
  """
    Permalink to access the order on merchant site.
    """
  line_items: list[order_line_item.OrderLineItem]
  """
    Immutable line items — source of truth for what was ordered.
    """
  fulfillment: Fulfillment
  """
    Fulfillment data: buyer expectations and what actually happened.
    """
  adjustments: list[adjustment.Adjustment] | None = None
  """
    Append-only event log of money movements (refunds, returns, credits, disputes, cancellations, etc.) that exist independently of fulfillment.
    """
  totals: list[total_resp.TotalResponse]
  """
    Different totals for the order.
    """
