# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from pydantic import AnyUrl, AwareDatetime, BaseModel, ConfigDict, Field


class LineItem(BaseModel):
  model_config = ConfigDict(
    extra="allow",
  )
  id: str
  """
    Line item ID reference.
    """
  quantity: int = Field(..., ge=1)
  """
    Quantity fulfilled in this event.
    """


class FulfillmentEvent(BaseModel):
  """Append-only fulfillment event representing an actual shipment. References line items by ID."""

  model_config = ConfigDict(
    extra="allow",
  )
  id: str
  """
    Fulfillment event identifier.
    """
  occurred_at: AwareDatetime
  """
    RFC 3339 timestamp when this fulfillment event occurred.
    """
  type: str
  """
    Fulfillment event type. Common values include: processing (preparing to ship), shipped (handed to carrier), in_transit (in delivery network), delivered (received by buyer), failed_attempt (delivery attempt failed), canceled (fulfillment canceled), undeliverable (cannot be delivered), returned_to_sender (returned to merchant).
    """
  line_items: list[LineItem]
  """
    Which line items and quantities are fulfilled in this event.
    """
  tracking_number: str | None = None
  """
    Carrier tracking number (required if type != processing).
    """
  tracking_url: AnyUrl | None = None
  """
    URL to track this shipment (required if type != processing).
    """
  carrier: str | None = None
  """
    Carrier name (e.g., 'FedEx', 'USPS').
    """
  description: str | None = None
  """
    Human-readable description of the shipment status or delivery information (e.g., 'Delivered to front door', 'Out for delivery').
    """
