# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from typing import Literal
from pydantic import BaseModel, ConfigDict
from . import fulfillment_destination_req, fulfillment_group_create_req


class FulfillmentMethodCreateRequest(BaseModel):
  """A fulfillment method (shipping or pickup) with destinations and groups."""

  model_config = ConfigDict(
    extra="allow",
  )
  type: Literal["shipping", "pickup"]
  """
    Fulfillment method type.
    """
  line_item_ids: list[str] | None = None
  """
    Line item IDs fulfilled via this method.
    """
  destinations: (
    list[fulfillment_destination_req.FulfillmentDestinationRequest] | None
  ) = None
  """
    Available destinations. For shipping: addresses. For pickup: retail locations.
    """
  selected_destination_id: str | None = None
  """
    ID of the selected destination.
    """
  groups: (
    list[fulfillment_group_create_req.FulfillmentGroupCreateRequest] | None
  ) = None
  """
    Fulfillment groups for selecting options. Agent sets selected_option_id on groups to choose shipping method.
    """
