# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from pydantic import BaseModel, ConfigDict, Field
from . import item_update_req


class LineItemUpdateRequest(BaseModel):
  """Line item object. Expected to use the currency of the parent object."""

  model_config = ConfigDict(
    extra="allow",
  )
  id: str | None = None
  item: item_update_req.ItemUpdateRequest
  quantity: int = Field(..., ge=1)
  """
    Quantity of the item being purchased.
    """
  parent_id: str | None = None
  """
    Parent line item identifier for any nested structures.
    """
