# Copyright 2026 UCP Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# generated by datamodel-codegen
# pylint: disable=all
# pyformat: disable

from __future__ import annotations

from pydantic import BaseModel, ConfigDict, Field
from typing import Literal
from . import item_resp, total_resp


class Quantity(BaseModel):
  """Quantity tracking. Both total and fulfilled are derived from events."""

  model_config = ConfigDict(
    extra="allow",
  )
  total: int = Field(..., ge=0)
  """
    Current total quantity.
    """
  fulfilled: int = Field(..., ge=0)
  """
    Quantity fulfilled (sum from fulfillment events).
    """


class OrderLineItem(BaseModel):
  model_config = ConfigDict(
    extra="allow",
  )
  id: str
  """
    Line item identifier.
    """
  item: item_resp.ItemResponse
  """
    Product data (id, title, price, image_url).
    """
  quantity: Quantity
  """
    Quantity tracking. Both total and fulfilled are derived from events.
    """
  totals: list[total_resp.TotalResponse]
  """
    Line item totals breakdown.
    """
  status: Literal["processing", "partial", "fulfilled"]
  """
    Derived status: fulfilled if quantity.fulfilled == quantity.total, partial if quantity.fulfilled > 0, otherwise processing.
    """
  parent_id: str | None = None
  """
    Parent line item identifier for any nested structures.
    """
