# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .action_item import ActionItem
from .crm_matches import CrmMatches
from .fathom_user import FathomUser
from .invitee import Invitee
from .meeting_meeting_type import MeetingMeetingType
from .meeting_summary import MeetingSummary
from .transcript_item import TranscriptItem


class Meeting(UniversalBaseModel):
    title: str
    meeting_title: str = pydantic.Field()
    """
    Calendar event title.
    """

    abstract: typing.Optional[str] = pydantic.Field(default=None)
    """
    Short meeting summary.
    """

    url: str
    share_url: str
    created_at: dt.datetime
    scheduled_start_time: dt.datetime
    scheduled_end_time: dt.datetime
    recording_start_time: dt.datetime
    recording_end_time: dt.datetime
    meeting_type: MeetingMeetingType
    transcript: typing.Optional[typing.List[TranscriptItem]] = None
    summary: typing.Optional[MeetingSummary] = None
    action_items: typing.Optional[typing.List[ActionItem]] = None
    calendar_invitees: typing.List[Invitee]
    transcript_language: str
    recorded_by: FathomUser
    crm_matches: typing.Optional[CrmMatches] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
