# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.meeting import Meeting
from .raw_client import AsyncRawMeetingsClient, RawMeetingsClient
from .types.list_meetings_request_meeting_type import ListMeetingsRequestMeetingType


class MeetingsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMeetingsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMeetingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMeetingsClient
        """
        return self._raw_client

    def list_meetings(
        self,
        *,
        calendar_invitees: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        calendar_invitees_domains: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        created_after: typing.Optional[str] = None,
        created_before: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        include_crm_matches: typing.Optional[bool] = None,
        include_transcript: typing.Optional[bool] = None,
        meeting_type: typing.Optional[ListMeetingsRequestMeetingType] = None,
        recorded_by: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        teams: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Meeting]:
        """
        Parameters
        ----------
        calendar_invitees : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email address of calendar_invitees to filter by.

            Pass the parameter once per value, e.g.
            `calendar_invitees[]=cfo@acme.com&calendar_invitees[]=legal@acme.com`.

            Returns meetings where any of the given email addresses appear
            in the calendar_invitees list.

        calendar_invitees_domains : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Domains of the companies to filter by. Exact match.

            Pass the parameter once per value, e.g.
            `calendar_invitees_domains[]=acme.com&calendar_invitees_domains[]=client.com`.

            Returns meetings where any of the given company domains appear in the meeting.

        created_after : typing.Optional[str]
            Filter to meetings with created_at after this timestamp, e.g. `created_after=2025-01-01T00:00:00Z`.

        created_before : typing.Optional[str]
            Filter to meetings with created_at before this timestamp, e.g. `created_before=2025-01-01T00:00:00Z`.

        cursor : typing.Optional[str]
            Cursor for pagination.

        include_crm_matches : typing.Optional[bool]
            Include CRM matches for each meeting. Only returns data from your or your team's linked CRM.

        include_transcript : typing.Optional[bool]
            Include the transcript for each meeting.

        meeting_type : typing.Optional[ListMeetingsRequestMeetingType]
            Filter by meeting type.

        recorded_by : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email addresses of meeting owners.

            Pass the parameter once per value, e.g.
            `recorded_by[]=ceo@acme.com&recorded_by[]=pm@acme.com`.

            Returns meetings hosted by any of the specified users.

        teams : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Team names to filter by.

            Pass the parameter once per value, e.g.
            `teams[]=Sales&teams[]=Engineering`.

            Returns meetings that belong to any of the specified teams.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Meeting]
            Paginated list of meetings.

        Examples
        --------
        from fathom import FathomApi
        client = FathomApi(api_key="YOUR_API_KEY", )
        response = client.meetings.list_meetings()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_meetings(
            calendar_invitees=calendar_invitees,
            calendar_invitees_domains=calendar_invitees_domains,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            include_crm_matches=include_crm_matches,
            include_transcript=include_transcript,
            meeting_type=meeting_type,
            recorded_by=recorded_by,
            teams=teams,
            request_options=request_options,
        )


class AsyncMeetingsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMeetingsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMeetingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMeetingsClient
        """
        return self._raw_client

    async def list_meetings(
        self,
        *,
        calendar_invitees: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        calendar_invitees_domains: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        created_after: typing.Optional[str] = None,
        created_before: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        include_crm_matches: typing.Optional[bool] = None,
        include_transcript: typing.Optional[bool] = None,
        meeting_type: typing.Optional[ListMeetingsRequestMeetingType] = None,
        recorded_by: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        teams: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Meeting]:
        """
        Parameters
        ----------
        calendar_invitees : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email address of calendar_invitees to filter by.

            Pass the parameter once per value, e.g.
            `calendar_invitees[]=cfo@acme.com&calendar_invitees[]=legal@acme.com`.

            Returns meetings where any of the given email addresses appear
            in the calendar_invitees list.

        calendar_invitees_domains : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Domains of the companies to filter by. Exact match.

            Pass the parameter once per value, e.g.
            `calendar_invitees_domains[]=acme.com&calendar_invitees_domains[]=client.com`.

            Returns meetings where any of the given company domains appear in the meeting.

        created_after : typing.Optional[str]
            Filter to meetings with created_at after this timestamp, e.g. `created_after=2025-01-01T00:00:00Z`.

        created_before : typing.Optional[str]
            Filter to meetings with created_at before this timestamp, e.g. `created_before=2025-01-01T00:00:00Z`.

        cursor : typing.Optional[str]
            Cursor for pagination.

        include_crm_matches : typing.Optional[bool]
            Include CRM matches for each meeting. Only returns data from your or your team's linked CRM.

        include_transcript : typing.Optional[bool]
            Include the transcript for each meeting.

        meeting_type : typing.Optional[ListMeetingsRequestMeetingType]
            Filter by meeting type.

        recorded_by : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email addresses of meeting owners.

            Pass the parameter once per value, e.g.
            `recorded_by[]=ceo@acme.com&recorded_by[]=pm@acme.com`.

            Returns meetings hosted by any of the specified users.

        teams : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Team names to filter by.

            Pass the parameter once per value, e.g.
            `teams[]=Sales&teams[]=Engineering`.

            Returns meetings that belong to any of the specified teams.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Meeting]
            Paginated list of meetings.

        Examples
        --------
        from fathom import AsyncFathomApi
        import asyncio
        client = AsyncFathomApi(api_key="YOUR_API_KEY", )
        async def main() -> None:
            response = await client.meetings.list_meetings()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page
        asyncio.run(main())
        """
        return await self._raw_client.list_meetings(
            calendar_invitees=calendar_invitees,
            calendar_invitees_domains=calendar_invitees_domains,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            include_crm_matches=include_crm_matches,
            include_transcript=include_transcript,
            meeting_type=meeting_type,
            recorded_by=recorded_by,
            teams=teams,
            request_options=request_options,
        )
