# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.team_member import TeamMember
from .raw_client import AsyncRawTeamMembersClient, RawTeamMembersClient


class TeamMembersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTeamMembersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTeamMembersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTeamMembersClient
        """
        return self._raw_client

    def list_team_members(
        self,
        *,
        cursor: typing.Optional[str] = None,
        team: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[TeamMember]:
        """
        Parameters
        ----------
        cursor : typing.Optional[str]
            Cursor for pagination.

        team : typing.Optional[str]
            Team name to filter by.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[TeamMember]
            Paginated list of team members.

        Examples
        --------
        from fathom import FathomApi
        client = FathomApi(api_key="YOUR_API_KEY", )
        response = client.team_members.list_team_members()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_team_members(cursor=cursor, team=team, request_options=request_options)


class AsyncTeamMembersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTeamMembersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTeamMembersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTeamMembersClient
        """
        return self._raw_client

    async def list_team_members(
        self,
        *,
        cursor: typing.Optional[str] = None,
        team: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[TeamMember]:
        """
        Parameters
        ----------
        cursor : typing.Optional[str]
            Cursor for pagination.

        team : typing.Optional[str]
            Team name to filter by.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[TeamMember]
            Paginated list of team members.

        Examples
        --------
        from fathom import AsyncFathomApi
        import asyncio
        client = AsyncFathomApi(api_key="YOUR_API_KEY", )
        async def main() -> None:
            response = await client.team_members.list_team_members()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page
        asyncio.run(main())
        """
        return await self._raw_client.list_team_members(cursor=cursor, team=team, request_options=request_options)
