# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.webhook import Webhook
from .raw_client import AsyncRawWebhooksClient, RawWebhooksClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WebhooksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWebhooksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWebhooksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWebhooksClient
        """
        return self._raw_client

    def create_webhook(
        self,
        *,
        destination_url: str,
        include_action_items: typing.Optional[bool] = OMIT,
        include_crm_matches: typing.Optional[bool] = OMIT,
        include_summary: typing.Optional[bool] = OMIT,
        include_transcript: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Webhook:
        """
        Create a webhook to receive new meeting content.
        At least one of `include_transcript`, `include_crm_matches`, `include_summary`, or `include_action_items` must be true.

        Parameters
        ----------
        destination_url : str
            The URL to send the webhook to.

        include_action_items : typing.Optional[bool]
            Include the action items for each meeting.

        include_crm_matches : typing.Optional[bool]
            Include CRM matches for each meeting. Only returns data from your or your team's linked CRM.

        include_summary : typing.Optional[bool]
            Include the summary for each meeting.

        include_transcript : typing.Optional[bool]
            Include the transcript for each meeting.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Webhook
            The created webhook.

        Examples
        --------
        from fathom import FathomApi
        client = FathomApi(api_key="YOUR_API_KEY", )
        client.webhooks.create_webhook(destination_url='https://example.com/webhook', )
        """
        _response = self._raw_client.create_webhook(
            destination_url=destination_url,
            include_action_items=include_action_items,
            include_crm_matches=include_crm_matches,
            include_summary=include_summary,
            include_transcript=include_transcript,
            request_options=request_options,
        )
        return _response.data

    def delete_webhook(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a webhook.

        Parameters
        ----------
        id : str
            The ID of the webhook to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from fathom import FathomApi
        client = FathomApi(api_key="YOUR_API_KEY", )
        client.webhooks.delete_webhook(id='id', )
        """
        _response = self._raw_client.delete_webhook(id, request_options=request_options)
        return _response.data


class AsyncWebhooksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWebhooksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWebhooksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWebhooksClient
        """
        return self._raw_client

    async def create_webhook(
        self,
        *,
        destination_url: str,
        include_action_items: typing.Optional[bool] = OMIT,
        include_crm_matches: typing.Optional[bool] = OMIT,
        include_summary: typing.Optional[bool] = OMIT,
        include_transcript: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Webhook:
        """
        Create a webhook to receive new meeting content.
        At least one of `include_transcript`, `include_crm_matches`, `include_summary`, or `include_action_items` must be true.

        Parameters
        ----------
        destination_url : str
            The URL to send the webhook to.

        include_action_items : typing.Optional[bool]
            Include the action items for each meeting.

        include_crm_matches : typing.Optional[bool]
            Include CRM matches for each meeting. Only returns data from your or your team's linked CRM.

        include_summary : typing.Optional[bool]
            Include the summary for each meeting.

        include_transcript : typing.Optional[bool]
            Include the transcript for each meeting.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Webhook
            The created webhook.

        Examples
        --------
        from fathom import AsyncFathomApi
        import asyncio
        client = AsyncFathomApi(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.webhooks.create_webhook(destination_url='https://example.com/webhook', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_webhook(
            destination_url=destination_url,
            include_action_items=include_action_items,
            include_crm_matches=include_crm_matches,
            include_summary=include_summary,
            include_transcript=include_transcript,
            request_options=request_options,
        )
        return _response.data

    async def delete_webhook(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a webhook.

        Parameters
        ----------
        id : str
            The ID of the webhook to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from fathom import AsyncFathomApi
        import asyncio
        client = AsyncFathomApi(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.webhooks.delete_webhook(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_webhook(id, request_options=request_options)
        return _response.data
