"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from fathom_python.types import BaseModel
from fathom_python.utils import FieldMetadata
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


GET_TOKEN_OP_SERVERS = [
    # Auth server
    "https://fathom.video/external/v1",
]


class GetTokenGrantType(str, Enum):
    AUTHORIZATION_CODE = "authorization_code"
    REFRESH_TOKEN = "refresh_token"


class GetTokenRequestTypedDict(TypedDict):
    grant_type: GetTokenGrantType
    code: str
    r"""authorization code received from `/authorize`"""
    redirect_uri: str
    r"""must match the redirect URI used in `/authorize`"""
    client_id: str
    client_secret: str
    refresh_token: NotRequired[str]
    r"""refresh token issued previously"""


class GetTokenRequest(BaseModel):
    grant_type: Annotated[GetTokenGrantType, FieldMetadata(form=True)]

    code: Annotated[str, FieldMetadata(form=True)]
    r"""authorization code received from `/authorize`"""

    redirect_uri: Annotated[str, FieldMetadata(form=True)]
    r"""must match the redirect URI used in `/authorize`"""

    client_id: Annotated[str, FieldMetadata(form=True)]

    client_secret: Annotated[str, FieldMetadata(form=True)]

    refresh_token: Annotated[Optional[str], FieldMetadata(form=True)] = None
    r"""refresh token issued previously"""


class GetTokenResponseTypedDict(TypedDict):
    r"""Access token (and optionally refresh token) response"""

    access_token: str
    expires_in: int
    r"""seconds until expiration"""
    refresh_token: str
    token_type: NotRequired[str]
    scope: NotRequired[str]


class GetTokenResponse(BaseModel):
    r"""Access token (and optionally refresh token) response"""

    access_token: str

    expires_in: int
    r"""seconds until expiration"""

    refresh_token: str

    token_type: Optional[str] = None

    scope: Optional[str] = None
