"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .callbackresponse import CallbackResponse, CallbackResponseTypedDict
from .meetingsummary import MeetingSummary, MeetingSummaryTypedDict
from fathom_python.types import BaseModel, Nullable, UNSET_SENTINEL
from fathom_python.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetRecordingSummaryRequestTypedDict(TypedDict):
    recording_id: int
    r"""The ID of the meeting recording to fetch the call summary for."""
    destination_url: NotRequired[str]
    r"""Destination URL for where we'll POST the call summary. If not sent, this endpoint will return the data directly."""


class GetRecordingSummaryRequest(BaseModel):
    recording_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the meeting recording to fetch the call summary for."""

    destination_url: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Destination URL for where we'll POST the call summary. If not sent, this endpoint will return the data directly."""


class GetRecordingSummaryResponseBodyTypedDict(TypedDict):
    summary: Nullable[MeetingSummaryTypedDict]


class GetRecordingSummaryResponseBody(BaseModel):
    summary: Nullable[MeetingSummary]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["summary"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GetRecordingSummaryResponseTypedDict = TypeAliasType(
    "GetRecordingSummaryResponseTypedDict",
    Union[GetRecordingSummaryResponseBodyTypedDict, CallbackResponseTypedDict],
)
r"""Either the destination URL for where we'll POST the call summary, or the summary for the recording."""


GetRecordingSummaryResponse = TypeAliasType(
    "GetRecordingSummaryResponse",
    Union[GetRecordingSummaryResponseBody, CallbackResponse],
)
r"""Either the destination URL for where we'll POST the call summary, or the summary for the recording."""
