"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .actionitem import ActionItem, ActionItemTypedDict
from .crmmatches import CRMMatches, CRMMatchesTypedDict
from .fathomuser import FathomUser, FathomUserTypedDict
from .invitee import Invitee, InviteeTypedDict
from .meetingsummary import MeetingSummary, MeetingSummaryTypedDict
from .transcriptitem import TranscriptItem, TranscriptItemTypedDict
from datetime import datetime
from enum import Enum
from fathom_python.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class CalendarInviteesDomainsType(str, Enum):
    ONLY_INTERNAL = "only_internal"
    ONE_OR_MORE_EXTERNAL = "one_or_more_external"


class MeetingTypedDict(TypedDict):
    title: str
    meeting_title: Nullable[str]
    r"""Calendar event title."""
    recording_id: int
    r"""The ID of the meeting recording."""
    url: str
    share_url: str
    created_at: datetime
    scheduled_start_time: datetime
    scheduled_end_time: datetime
    recording_start_time: datetime
    recording_end_time: datetime
    calendar_invitees_domains_type: CalendarInviteesDomainsType
    transcript_language: str
    calendar_invitees: List[InviteeTypedDict]
    recorded_by: FathomUserTypedDict
    transcript: NotRequired[Nullable[List[TranscriptItemTypedDict]]]
    default_summary: NotRequired[Nullable[MeetingSummaryTypedDict]]
    action_items: NotRequired[Nullable[List[ActionItemTypedDict]]]
    crm_matches: NotRequired[Nullable[CRMMatchesTypedDict]]
    r"""CRM data linked to the meeting. Only returns data from your or your team's linked CRM.
    If no CRM is connected for the workspace, the `error` field will be populated.

    """


class Meeting(BaseModel):
    title: str

    meeting_title: Nullable[str]
    r"""Calendar event title."""

    recording_id: int
    r"""The ID of the meeting recording."""

    url: str

    share_url: str

    created_at: datetime

    scheduled_start_time: datetime

    scheduled_end_time: datetime

    recording_start_time: datetime

    recording_end_time: datetime

    calendar_invitees_domains_type: CalendarInviteesDomainsType

    transcript_language: str

    calendar_invitees: List[Invitee]

    recorded_by: FathomUser

    transcript: OptionalNullable[List[TranscriptItem]] = UNSET

    default_summary: OptionalNullable[MeetingSummary] = UNSET

    action_items: OptionalNullable[List[ActionItem]] = UNSET

    crm_matches: OptionalNullable[CRMMatches] = UNSET
    r"""CRM data linked to the meeting. Only returns data from your or your team's linked CRM.
    If no CRM is connected for the workspace, the `error` field will be populated.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "transcript",
            "default_summary",
            "action_items",
            "crm_matches",
        ]
        nullable_fields = [
            "meeting_title",
            "transcript",
            "default_summary",
            "action_items",
            "crm_matches",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
