# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.26
    Contact: info@fattureincloud.it
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr

from typing import Optional

from fattureincloud_python_sdk.models.create_receipt_request import CreateReceiptRequest
from fattureincloud_python_sdk.models.create_receipt_response import (
    CreateReceiptResponse,
)
from fattureincloud_python_sdk.models.get_receipt_pre_create_info_response import (
    GetReceiptPreCreateInfoResponse,
)
from fattureincloud_python_sdk.models.get_receipt_response import GetReceiptResponse
from fattureincloud_python_sdk.models.get_receipts_monthly_totals_response import (
    GetReceiptsMonthlyTotalsResponse,
)
from fattureincloud_python_sdk.models.list_receipts_response import ListReceiptsResponse
from fattureincloud_python_sdk.models.modify_receipt_request import ModifyReceiptRequest
from fattureincloud_python_sdk.models.modify_receipt_response import (
    ModifyReceiptResponse,
)

from fattureincloud_python_sdk.api_client import ApiClient
from fattureincloud_python_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError,
)


class ReceiptsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_receipt(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        create_receipt_request: Annotated[
            Optional[CreateReceiptRequest], Field(description="The Receipt to create.")
        ] = None,
        **kwargs
    ) -> CreateReceiptResponse:  # noqa: E501
        """Create Receipt  # noqa: E501

        Creates a new receipt.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_receipt(company_id, create_receipt_request, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param create_receipt_request: The Receipt to create.
        :type create_receipt_request: CreateReceiptRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateReceiptResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.create_receipt_with_http_info(
            company_id, create_receipt_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def create_receipt_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        create_receipt_request: Annotated[
            Optional[CreateReceiptRequest], Field(description="The Receipt to create.")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Create Receipt  # noqa: E501

        Creates a new receipt.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_receipt_with_http_info(company_id, create_receipt_request, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param create_receipt_request: The Receipt to create.
        :type create_receipt_request: CreateReceiptRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateReceiptResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id", "create_receipt_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_receipt" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["create_receipt_request"]:
            _body_params = _params["create_receipt_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "CreateReceiptResponse",
            "401": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/receipts",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_receipt(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        document_id: Annotated[
            StrictInt, Field(..., description="The ID of the document.")
        ],
        **kwargs
    ) -> None:  # noqa: E501
        """Delete Receipt  # noqa: E501

        Deletes the specified receipt.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_receipt(company_id, document_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param document_id: The ID of the document. (required)
        :type document_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_receipt_with_http_info(
            company_id, document_id, **kwargs
        )  # noqa: E501

    @validate_arguments
    def delete_receipt_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        document_id: Annotated[
            StrictInt, Field(..., description="The ID of the document.")
        ],
        **kwargs
    ):  # noqa: E501
        """Delete Receipt  # noqa: E501

        Deletes the specified receipt.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_receipt_with_http_info(company_id, document_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param document_id: The ID of the document. (required)
        :type document_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["company_id", "document_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_receipt" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]
        if _params["document_id"]:
            _path_params["document_id"] = _params["document_id"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/c/{company_id}/receipts/{document_id}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_receipt(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        document_id: Annotated[
            StrictInt, Field(..., description="The ID of the document.")
        ],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        **kwargs
    ) -> GetReceiptResponse:  # noqa: E501
        """Get Receipt  # noqa: E501

        Gets the specified receipt.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_receipt(company_id, document_id, fields, fieldset, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param document_id: The ID of the document. (required)
        :type document_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetReceiptResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.get_receipt_with_http_info(
            company_id, document_id, fields, fieldset, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_receipt_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        document_id: Annotated[
            StrictInt, Field(..., description="The ID of the document.")
        ],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Get Receipt  # noqa: E501

        Gets the specified receipt.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_receipt_with_http_info(company_id, document_id, fields, fieldset, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param document_id: The ID of the document. (required)
        :type document_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetReceiptResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id", "document_id", "fields", "fieldset"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_receipt" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]
        if _params["document_id"]:
            _path_params["document_id"] = _params["document_id"]

        # process the query parameters
        _query_params = []
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fieldset") is not None:  # noqa: E501
            _query_params.append(("fieldset", _params["fieldset"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "GetReceiptResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/receipts/{document_id}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_receipt_pre_create_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        **kwargs
    ) -> GetReceiptPreCreateInfoResponse:  # noqa: E501
        """Get Receipt Pre-Create Info  # noqa: E501

        Retrieves the information useful while creating a new receipt.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_receipt_pre_create_info(company_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetReceiptPreCreateInfoResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.get_receipt_pre_create_info_with_http_info(
            company_id, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_receipt_pre_create_info_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        **kwargs
    ):  # noqa: E501
        """Get Receipt Pre-Create Info  # noqa: E501

        Retrieves the information useful while creating a new receipt.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_receipt_pre_create_info_with_http_info(company_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetReceiptPreCreateInfoResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_receipt_pre_create_info" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "GetReceiptPreCreateInfoResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/receipts/info",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_receipts_monthly_totals(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        type: Annotated[StrictStr, Field(..., description="Receipt Type")],
        year: Annotated[
            StrictStr, Field(..., description="Year for which you want monthly totals")
        ],
        **kwargs
    ) -> GetReceiptsMonthlyTotalsResponse:  # noqa: E501
        """Get Receipts Monthly Totals  # noqa: E501

        Returns the monthly totals by year and receipt type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_receipts_monthly_totals(company_id, type, year, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param type: Receipt Type (required)
        :type type: str
        :param year: Year for which you want monthly totals (required)
        :type year: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetReceiptsMonthlyTotalsResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.get_receipts_monthly_totals_with_http_info(
            company_id, type, year, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_receipts_monthly_totals_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        type: Annotated[StrictStr, Field(..., description="Receipt Type")],
        year: Annotated[
            StrictStr, Field(..., description="Year for which you want monthly totals")
        ],
        **kwargs
    ):  # noqa: E501
        """Get Receipts Monthly Totals  # noqa: E501

        Returns the monthly totals by year and receipt type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_receipts_monthly_totals_with_http_info(company_id, type, year, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param type: Receipt Type (required)
        :type type: str
        :param year: Year for which you want monthly totals (required)
        :type year: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetReceiptsMonthlyTotalsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id", "type", "year"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_receipts_monthly_totals" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []
        if _params.get("type") is not None:  # noqa: E501
            _query_params.append(("type", _params["type"]))
        if _params.get("year") is not None:  # noqa: E501
            _query_params.append(("year", _params["year"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "GetReceiptsMonthlyTotalsResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/receipts/monthly_totals",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_receipts(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        page: Annotated[
            Optional[StrictInt], Field(description="The page to retrieve.")
        ] = None,
        per_page: Annotated[
            Optional[StrictInt], Field(description="The size of the page.")
        ] = None,
        sort: Annotated[
            Optional[StrictStr],
            Field(
                description="List of comma-separated fields for result sorting (minus for desc sorting)."
            ),
        ] = None,
        q: Annotated[
            Optional[StrictStr], Field(description="Query for filtering the results.")
        ] = None,
        **kwargs
    ) -> ListReceiptsResponse:  # noqa: E501
        """List Receipts  # noqa: E501

        Lists the receipts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_receipts(company_id, fields, fieldset, page, per_page, sort, q, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param page: The page to retrieve.
        :type page: int
        :param per_page: The size of the page.
        :type per_page: int
        :param sort: List of comma-separated fields for result sorting (minus for desc sorting).
        :type sort: str
        :param q: Query for filtering the results.
        :type q: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListReceiptsResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_receipts_with_http_info(
            company_id, fields, fieldset, page, per_page, sort, q, **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_receipts_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        page: Annotated[
            Optional[StrictInt], Field(description="The page to retrieve.")
        ] = None,
        per_page: Annotated[
            Optional[StrictInt], Field(description="The size of the page.")
        ] = None,
        sort: Annotated[
            Optional[StrictStr],
            Field(
                description="List of comma-separated fields for result sorting (minus for desc sorting)."
            ),
        ] = None,
        q: Annotated[
            Optional[StrictStr], Field(description="Query for filtering the results.")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """List Receipts  # noqa: E501

        Lists the receipts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_receipts_with_http_info(company_id, fields, fieldset, page, per_page, sort, q, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param page: The page to retrieve.
        :type page: int
        :param per_page: The size of the page.
        :type per_page: int
        :param sort: List of comma-separated fields for result sorting (minus for desc sorting).
        :type sort: str
        :param q: Query for filtering the results.
        :type q: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListReceiptsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "company_id",
            "fields",
            "fieldset",
            "page",
            "per_page",
            "sort",
            "q",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_receipts" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))
        if _params.get("fieldset") is not None:  # noqa: E501
            _query_params.append(("fieldset", _params["fieldset"]))
        if _params.get("page") is not None:  # noqa: E501
            _query_params.append(("page", _params["page"]))
        if _params.get("per_page") is not None:  # noqa: E501
            _query_params.append(("per_page", _params["per_page"]))
        if _params.get("sort") is not None:  # noqa: E501
            _query_params.append(("sort", _params["sort"]))
        if _params.get("q") is not None:  # noqa: E501
            _query_params.append(("q", _params["q"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListReceiptsResponse",
            "401": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/receipts",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def modify_receipt(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        document_id: Annotated[
            StrictInt, Field(..., description="The ID of the document.")
        ],
        modify_receipt_request: Annotated[
            Optional[ModifyReceiptRequest], Field(description="Modified receipt.")
        ] = None,
        **kwargs
    ) -> ModifyReceiptResponse:  # noqa: E501
        """Modify Receipt  # noqa: E501

        Modifies the specified receipt.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_receipt(company_id, document_id, modify_receipt_request, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param document_id: The ID of the document. (required)
        :type document_id: int
        :param modify_receipt_request: Modified receipt.
        :type modify_receipt_request: ModifyReceiptRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ModifyReceiptResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.modify_receipt_with_http_info(
            company_id, document_id, modify_receipt_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def modify_receipt_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        document_id: Annotated[
            StrictInt, Field(..., description="The ID of the document.")
        ],
        modify_receipt_request: Annotated[
            Optional[ModifyReceiptRequest], Field(description="Modified receipt.")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Modify Receipt  # noqa: E501

        Modifies the specified receipt.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_receipt_with_http_info(company_id, document_id, modify_receipt_request, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param document_id: The ID of the document. (required)
        :type document_id: int
        :param modify_receipt_request: Modified receipt.
        :type modify_receipt_request: ModifyReceiptRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ModifyReceiptResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id", "document_id", "modify_receipt_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_receipt" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]
        if _params["document_id"]:
            _path_params["document_id"] = _params["document_id"]

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["modify_receipt_request"]:
            _body_params = _params["modify_receipt_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ModifyReceiptResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/receipts/{document_id}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
