# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.26
    Contact: info@fattureincloud.it
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr
from fattureincloud_python_sdk.models.email_attachment import EmailAttachment
from fattureincloud_python_sdk.models.email_recipient_status import EmailRecipientStatus
from fattureincloud_python_sdk.models.email_status import EmailStatus


class Email(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    id: Optional[StrictInt] = Field(None, description="Email unique identifier.")
    status: Optional[EmailStatus] = None
    sent_date: Optional[datetime] = Field(None, description="Email sent date.")
    errors_count: Optional[StrictInt] = Field(None, description="Errors count.")
    error_log: Optional[StrictStr] = Field(None, description="Error log.")
    from_email: Optional[StrictStr] = Field(None, description="Sender email.")
    from_name: Optional[StrictStr] = Field(None, description="Sender name.")
    to_email: Optional[StrictStr] = Field(None, description="Recipient email.")
    to_name: Optional[StrictStr] = Field(None, description="Receipient email.")
    subject: Optional[StrictStr] = Field(None, description="Email subject.")
    content: Optional[StrictStr] = Field(None, description="Email content.")
    copy_to: Optional[StrictStr] = None
    recipient_status: Optional[EmailRecipientStatus] = None
    recipient_date: Optional[datetime] = None
    kind: Optional[StrictStr] = Field(None, description="Email kind.")
    attachments: Optional[List[EmailAttachment]] = Field(
        None, description="Email attachments."
    )
    __properties = [
        "id",
        "status",
        "sent_date",
        "errors_count",
        "error_log",
        "from_email",
        "from_name",
        "to_email",
        "to_name",
        "subject",
        "content",
        "copy_to",
        "recipient_status",
        "recipient_date",
        "kind",
        "attachments",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Email:
        """Create an instance of Email from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict["attachments"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Email:
        """Create an instance of Email from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Email.parse_obj(obj)

        _obj = Email.parse_obj(
            {
                "id": obj.get("id") if obj.get("id") is not None else None,
                "status": obj.get("status"),
                "sent_date": obj.get("sent_date")
                if obj.get("sent_date") is not None
                else None,
                "errors_count": obj.get("errors_count")
                if obj.get("errors_count") is not None
                else None,
                "error_log": obj.get("error_log")
                if obj.get("error_log") is not None
                else None,
                "from_email": obj.get("from_email")
                if obj.get("from_email") is not None
                else None,
                "from_name": obj.get("from_name")
                if obj.get("from_name") is not None
                else None,
                "to_email": obj.get("to_email")
                if obj.get("to_email") is not None
                else None,
                "to_name": obj.get("to_name")
                if obj.get("to_name") is not None
                else None,
                "subject": obj.get("subject")
                if obj.get("subject") is not None
                else None,
                "content": obj.get("content")
                if obj.get("content") is not None
                else None,
                "copy_to": obj.get("copy_to")
                if obj.get("copy_to") is not None
                else None,
                "recipient_status": obj.get("recipient_status"),
                "recipient_date": obj.get("recipient_date")
                if obj.get("recipient_date") is not None
                else None,
                "kind": obj.get("kind") if obj.get("kind") is not None else None,
                "attachments": [
                    EmailAttachment.from_dict(_item) for _item in obj.get("attachments")
                ]
                if obj.get("attachments") is not None
                else None,
            }
        )
        return _obj
