# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.26
    Contact: info@fattureincloud.it
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from fattureincloud_python_sdk.models.payment_account import PaymentAccount
from fattureincloud_python_sdk.models.payment_method_details import PaymentMethodDetails
from fattureincloud_python_sdk.models.payment_method_type import PaymentMethodType


class PaymentMethod(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    id: Optional[StrictInt] = Field(None, description="Unique identifier")
    name: Optional[StrictStr] = Field(None, description="Name of the payment method")
    type: Optional[PaymentMethodType] = None
    is_default: Optional[StrictBool] = Field(
        None, description="Determines if this is the default payment method."
    )
    default_payment_account: Optional[PaymentAccount] = None
    details: Optional[List[PaymentMethodDetails]] = Field(
        None, description="Method details rows"
    )
    bank_iban: Optional[StrictStr] = Field(None, description="Bank iban")
    bank_name: Optional[StrictStr] = Field(None, description="Bank name")
    bank_beneficiary: Optional[StrictStr] = Field(None, description="Bank beneficiary")
    ei_payment_method: Optional[StrictStr] = Field(
        None, description="E-invoice payment method"
    )
    __properties = [
        "id",
        "name",
        "type",
        "is_default",
        "default_payment_account",
        "details",
        "bank_iban",
        "bank_name",
        "bank_beneficiary",
        "ei_payment_method",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PaymentMethod:
        """Create an instance of PaymentMethod from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of default_payment_account
        if self.default_payment_account:
            _dict["default_payment_account"] = self.default_payment_account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in details (list)
        _items = []
        if self.details:
            for _item in self.details:
                if _item:
                    _items.append(_item.to_dict())
            _dict["details"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PaymentMethod:
        """Create an instance of PaymentMethod from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PaymentMethod.parse_obj(obj)

        _obj = PaymentMethod.parse_obj(
            {
                "id": obj.get("id") if obj.get("id") is not None else None,
                "name": obj.get("name") if obj.get("name") is not None else None,
                "type": obj.get("type"),
                "is_default": obj.get("is_default")
                if obj.get("is_default") is not None
                else None,
                "default_payment_account": PaymentAccount.from_dict(
                    obj.get("default_payment_account")
                )
                if obj.get("default_payment_account") is not None
                else None,
                "details": [
                    PaymentMethodDetails.from_dict(_item)
                    for _item in obj.get("details")
                ]
                if obj.get("details") is not None
                else None,
                "bank_iban": obj.get("bank_iban")
                if obj.get("bank_iban") is not None
                else None,
                "bank_name": obj.get("bank_name")
                if obj.get("bank_name") is not None
                else None,
                "bank_beneficiary": obj.get("bank_beneficiary")
                if obj.get("bank_beneficiary") is not None
                else None,
                "ei_payment_method": obj.get("ei_payment_method")
                if obj.get("ei_payment_method") is not None
                else None,
            }
        )
        return _obj
