"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 400.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.9
    Contact: info@fattureincloud.it
    Generated by: https://openapi-generator.tech
"""


import json
import sys
import unittest
import datetime
import fattureincloud_python_sdk
from functions import json_serial
from functions import create_from_json
from fattureincloud_python_sdk.models.currency import Currency
from fattureincloud_python_sdk.models.document_template import DocumentTemplate
from fattureincloud_python_sdk.models.entity import Entity
from fattureincloud_python_sdk.models.issued_document_ei_data import IssuedDocumentEiData
from fattureincloud_python_sdk.models.issued_document_extra_data import (
    IssuedDocumentExtraData,
)
from fattureincloud_python_sdk.models.issued_document_items_list_item import (
    IssuedDocumentItemsListItem,
)
from fattureincloud_python_sdk.models.issued_document_payments_list_item import (
    IssuedDocumentPaymentsListItem,
)
from fattureincloud_python_sdk.models.issued_document_type import IssuedDocumentType
from fattureincloud_python_sdk.models.language import Language
from fattureincloud_python_sdk.models.payment_method import PaymentMethod
from fattureincloud_python_sdk.models.show_totals_mode import ShowTotalsMode

globals()["Currency"] = Currency
globals()["DocumentTemplate"] = DocumentTemplate
globals()["Entity"] = Entity
globals()["IssuedDocumentEiData"] = IssuedDocumentEiData
globals()["IssuedDocumentExtraData"] = IssuedDocumentExtraData
globals()["IssuedDocumentItemsListItem"] = IssuedDocumentItemsListItem
globals()["IssuedDocumentPaymentsListItem"] = IssuedDocumentPaymentsListItem
globals()["IssuedDocumentType"] = IssuedDocumentType
globals()["Language"] = Language
globals()["PaymentMethod"] = PaymentMethod
globals()["ShowTotalsMode"] = ShowTotalsMode
from fattureincloud_python_sdk.models.issued_document import IssuedDocument


class TestIssuedDocument(unittest.TestCase):
    """IssuedDocument unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testIssuedDocument(self):
        """Test IssuedDocument"""
        model = IssuedDocument(
            id=1,
            type=IssuedDocumentType("invoice"),
            number=1,
            numeration="/A",
            date=datetime.datetime.strptime("2022-01-01", "%Y-%m-%d").date(),
            year=1,
            subject="subject_example",
            visible_subject="visible_subject_example",
            rc_center="rc_center_example",
            notes="notes_example",
            rivalsa=0.0,
            cassa=0.0,
            cassa_taxable=0.0,
            amount_cassa_taxable=3.14,
            cassa2=0.0,
            cassa2_taxable=0.0,
            amount_cassa2_taxable=3.14,
            global_cassa_taxable=0.0,
            amount_global_cassa_taxable=3.14,
        )
        expected_json = '{"id": 1, "type": "invoice", "number": 1, "numeration": "/A", "date": "2022-01-01", "year": 1, "subject": "subject_example", "visible_subject": "visible_subject_example", "rc_center": "rc_center_example", "notes": "notes_example", "rivalsa": 0.0, "cassa": 0.0, "cassa_taxable": 0.0, "amount_cassa_taxable": 3.14, "cassa2": 0.0, "cassa2_taxable": 0.0, "amount_cassa2_taxable": 3.14, "global_cassa_taxable": 0.0, "amount_global_cassa_taxable": 3.14}'
        actual_json = json.dumps(model.to_dict(), default=json_serial)
        assert actual_json == expected_json

        readonly_json = '{"id": 1, "type": "invoice", "number": 1, "numeration": "/A", "date": "2022-01-01", "year": 1, "subject": "subject_example", "visible_subject": "visible_subject_example", "rc_center": "rc_center_example", "notes": "notes_example", "rivalsa": 0.0, "cassa": 0.0, "cassa_taxable": 0.0, "amount_cassa_taxable": 3.14, "cassa2": 0.0, "cassa2_taxable": 0.0, "amount_cassa2_taxable": 3.14, "global_cassa_taxable": 0.0, "amount_global_cassa_taxable": 3.14, "attachment_token": "attachment_token_example", "attachment_url": "spesa2.pdf"}'
        model = IssuedDocument(
            id=1,
            type=IssuedDocumentType("invoice"),
            number=1,
            numeration="/A",
            date=datetime.datetime.strptime("2022-01-01", "%Y-%m-%d").date(),
            year=1,
            subject="subject_example",
            visible_subject="visible_subject_example",
            rc_center="rc_center_example",
            notes="notes_example",
            rivalsa=0.0,
            cassa=0.0,
            cassa_taxable=0.0,
            amount_cassa_taxable=3.14,
            cassa2=0.0,
            cassa2_taxable=0.0,
            amount_cassa2_taxable=3.14,
            global_cassa_taxable=0.0,
            amount_global_cassa_taxable=3.14,
            attachment_token="attachment_token_example",
            description="description_example",
        )
        model = create_from_json(readonly_json, "IssuedDocument")


if __name__ == "__main__":
    unittest.main()
