# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.27
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr

from typing import Optional

from fattureincloud_python_sdk.models.list_archive_categories_response import (
    ListArchiveCategoriesResponse,
)
from fattureincloud_python_sdk.models.list_cities_response import ListCitiesResponse
from fattureincloud_python_sdk.models.list_cost_centers_response import (
    ListCostCentersResponse,
)
from fattureincloud_python_sdk.models.list_countries_response import (
    ListCountriesResponse,
)
from fattureincloud_python_sdk.models.list_currencies_response import (
    ListCurrenciesResponse,
)
from fattureincloud_python_sdk.models.list_delivery_notes_default_causals_response import (
    ListDeliveryNotesDefaultCausalsResponse,
)
from fattureincloud_python_sdk.models.list_detailed_countries_response import (
    ListDetailedCountriesResponse,
)
from fattureincloud_python_sdk.models.list_languages_response import (
    ListLanguagesResponse,
)
from fattureincloud_python_sdk.models.list_payment_accounts_response import (
    ListPaymentAccountsResponse,
)
from fattureincloud_python_sdk.models.list_payment_methods_response import (
    ListPaymentMethodsResponse,
)
from fattureincloud_python_sdk.models.list_product_categories_response import (
    ListProductCategoriesResponse,
)
from fattureincloud_python_sdk.models.list_received_document_categories_response import (
    ListReceivedDocumentCategoriesResponse,
)
from fattureincloud_python_sdk.models.list_revenue_centers_response import (
    ListRevenueCentersResponse,
)
from fattureincloud_python_sdk.models.list_templates_response import (
    ListTemplatesResponse,
)
from fattureincloud_python_sdk.models.list_units_of_measure_response import (
    ListUnitsOfMeasureResponse,
)
from fattureincloud_python_sdk.models.list_vat_types_response import (
    ListVatTypesResponse,
)

from fattureincloud_python_sdk.api_client import ApiClient
from fattureincloud_python_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError,
)


class InfoApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def list_archive_categories(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        **kwargs
    ) -> ListArchiveCategoriesResponse:  # noqa: E501
        """List Archive Categories  # noqa: E501

        Lists the archive categories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_archive_categories(company_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListArchiveCategoriesResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_archive_categories_with_http_info(
            company_id, **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_archive_categories_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        **kwargs
    ):  # noqa: E501
        """List Archive Categories  # noqa: E501

        Lists the archive categories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_archive_categories_with_http_info(company_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListArchiveCategoriesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_archive_categories" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListArchiveCategoriesResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/info/archive_categories",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_cities(
        self,
        postal_code: Annotated[
            Optional[StrictStr], Field(description="Postal code for filtering.")
        ] = None,
        city: Annotated[
            Optional[StrictStr],
            Field(description="City for filtering (ignored if postal_code is passed)."),
        ] = None,
        **kwargs
    ) -> ListCitiesResponse:  # noqa: E501
        """List Cities  # noqa: E501

        Lists the Italian cities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cities(postal_code, city, async_req=True)
        >>> result = thread.get()

        :param postal_code: Postal code for filtering.
        :type postal_code: str
        :param city: City for filtering (ignored if postal_code is passed).
        :type city: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListCitiesResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_cities_with_http_info(
            postal_code, city, **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_cities_with_http_info(
        self,
        postal_code: Annotated[
            Optional[StrictStr], Field(description="Postal code for filtering.")
        ] = None,
        city: Annotated[
            Optional[StrictStr],
            Field(description="City for filtering (ignored if postal_code is passed)."),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """List Cities  # noqa: E501

        Lists the Italian cities.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cities_with_http_info(postal_code, city, async_req=True)
        >>> result = thread.get()

        :param postal_code: Postal code for filtering.
        :type postal_code: str
        :param city: City for filtering (ignored if postal_code is passed).
        :type city: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListCitiesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["postal_code", "city"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cities" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get("postal_code") is not None:  # noqa: E501
            _query_params.append(("postal_code", _params["postal_code"]))

        if _params.get("city") is not None:  # noqa: E501
            _query_params.append(("city", _params["city"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListCitiesResponse",
        }

        return self.api_client.call_api(
            "/info/cities",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_cost_centers(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        **kwargs
    ) -> ListCostCentersResponse:  # noqa: E501
        """List Cost Centers  # noqa: E501

        Lists the cost centers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cost_centers(company_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListCostCentersResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_cost_centers_with_http_info(company_id, **kwargs)  # noqa: E501

    @validate_arguments
    def list_cost_centers_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        **kwargs
    ):  # noqa: E501
        """List Cost Centers  # noqa: E501

        Lists the cost centers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cost_centers_with_http_info(company_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListCostCentersResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cost_centers" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListCostCentersResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/info/cost_centers",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_countries(self, **kwargs) -> ListCountriesResponse:  # noqa: E501
        """List Countries  # noqa: E501

        Lists the supported countries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_countries(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListCountriesResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_countries_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def list_countries_with_http_info(self, **kwargs):  # noqa: E501
        """List Countries  # noqa: E501

        Lists the supported countries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_countries_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListCountriesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_countries" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListCountriesResponse",
            "401": None,
        }

        return self.api_client.call_api(
            "/info/countries",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_currencies(self, **kwargs) -> ListCurrenciesResponse:  # noqa: E501
        """List Currencies  # noqa: E501

        Lists the supported currencies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_currencies(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListCurrenciesResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_currencies_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def list_currencies_with_http_info(self, **kwargs):  # noqa: E501
        """List Currencies  # noqa: E501

        Lists the supported currencies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_currencies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListCurrenciesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_currencies" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListCurrenciesResponse",
            "401": None,
        }

        return self.api_client.call_api(
            "/info/currencies",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_delivery_notes_default_causals(
        self, **kwargs
    ) -> ListDeliveryNotesDefaultCausalsResponse:  # noqa: E501
        """List Delivery Notes Default Causals  # noqa: E501

        Lists the delivery note default causals.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_delivery_notes_default_causals(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListDeliveryNotesDefaultCausalsResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_delivery_notes_default_causals_with_http_info(
            **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_delivery_notes_default_causals_with_http_info(
        self, **kwargs
    ):  # noqa: E501
        """List Delivery Notes Default Causals  # noqa: E501

        Lists the delivery note default causals.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_delivery_notes_default_causals_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListDeliveryNotesDefaultCausalsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_delivery_notes_default_causals" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListDeliveryNotesDefaultCausalsResponse",
            "401": None,
        }

        return self.api_client.call_api(
            "/info/dn_causals",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_detailed_countries(
        self, **kwargs
    ) -> ListDetailedCountriesResponse:  # noqa: E501
        """List Detailed Countries  # noqa: E501

        Lists the supported countries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_detailed_countries(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListDetailedCountriesResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_detailed_countries_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def list_detailed_countries_with_http_info(self, **kwargs):  # noqa: E501
        """List Detailed Countries  # noqa: E501

        Lists the supported countries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_detailed_countries_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListDetailedCountriesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_detailed_countries" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListDetailedCountriesResponse",
            "401": None,
        }

        return self.api_client.call_api(
            "/info/detailed_countries",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_languages(self, **kwargs) -> ListLanguagesResponse:  # noqa: E501
        """List Languages  # noqa: E501

        Lists the supported languages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_languages(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListLanguagesResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_languages_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def list_languages_with_http_info(self, **kwargs):  # noqa: E501
        """List Languages  # noqa: E501

        Lists the supported languages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_languages_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListLanguagesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_languages" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListLanguagesResponse",
            "401": None,
        }

        return self.api_client.call_api(
            "/info/languages",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_payment_accounts(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        sort: Annotated[
            Optional[StrictStr],
            Field(
                description="List of comma-separated fields for result sorting (minus for desc sorting)."
            ),
        ] = None,
        **kwargs
    ) -> ListPaymentAccountsResponse:  # noqa: E501
        """List Payment Accounts  # noqa: E501

        Lists the available payment accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payment_accounts(company_id, fields, fieldset, sort, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param sort: List of comma-separated fields for result sorting (minus for desc sorting).
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListPaymentAccountsResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_payment_accounts_with_http_info(
            company_id, fields, fieldset, sort, **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_payment_accounts_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        sort: Annotated[
            Optional[StrictStr],
            Field(
                description="List of comma-separated fields for result sorting (minus for desc sorting)."
            ),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """List Payment Accounts  # noqa: E501

        Lists the available payment accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payment_accounts_with_http_info(company_id, fields, fieldset, sort, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param sort: List of comma-separated fields for result sorting (minus for desc sorting).
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListPaymentAccountsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id", "fields", "fieldset", "sort"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_payment_accounts" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("fieldset") is not None:  # noqa: E501
            _query_params.append(("fieldset", _params["fieldset"]))

        if _params.get("sort") is not None:  # noqa: E501
            _query_params.append(("sort", _params["sort"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListPaymentAccountsResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/info/payment_accounts",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_payment_methods(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        sort: Annotated[
            Optional[StrictStr],
            Field(
                description="List of comma-separated fields for result sorting (minus for desc sorting)."
            ),
        ] = None,
        **kwargs
    ) -> ListPaymentMethodsResponse:  # noqa: E501
        """List Payment Methods  # noqa: E501

        Lists the available payment methods.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payment_methods(company_id, fields, fieldset, sort, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param sort: List of comma-separated fields for result sorting (minus for desc sorting).
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListPaymentMethodsResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_payment_methods_with_http_info(
            company_id, fields, fieldset, sort, **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_payment_methods_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        sort: Annotated[
            Optional[StrictStr],
            Field(
                description="List of comma-separated fields for result sorting (minus for desc sorting)."
            ),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """List Payment Methods  # noqa: E501

        Lists the available payment methods.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payment_methods_with_http_info(company_id, fields, fieldset, sort, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param sort: List of comma-separated fields for result sorting (minus for desc sorting).
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListPaymentMethodsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id", "fields", "fieldset", "sort"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_payment_methods" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("fieldset") is not None:  # noqa: E501
            _query_params.append(("fieldset", _params["fieldset"]))

        if _params.get("sort") is not None:  # noqa: E501
            _query_params.append(("sort", _params["sort"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListPaymentMethodsResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/info/payment_methods",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_product_categories(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        context: StrictStr,
        **kwargs
    ) -> ListProductCategoriesResponse:  # noqa: E501
        """List Product Categories  # noqa: E501

        Lists the product categories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_product_categories(company_id, context, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param context: (required)
        :type context: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListProductCategoriesResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_product_categories_with_http_info(
            company_id, context, **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_product_categories_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        context: StrictStr,
        **kwargs
    ):  # noqa: E501
        """List Product Categories  # noqa: E501

        Lists the product categories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_product_categories_with_http_info(company_id, context, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param context: (required)
        :type context: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListProductCategoriesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id", "context"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_product_categories" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []
        if _params.get("context") is not None:  # noqa: E501
            _query_params.append(("context", _params["context"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListProductCategoriesResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/info/product_categories",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_received_document_categories(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        **kwargs
    ) -> ListReceivedDocumentCategoriesResponse:  # noqa: E501
        """List Received Document Categories  # noqa: E501

        Lists the received document categories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_received_document_categories(company_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListReceivedDocumentCategoriesResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_received_document_categories_with_http_info(
            company_id, **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_received_document_categories_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        **kwargs
    ):  # noqa: E501
        """List Received Document Categories  # noqa: E501

        Lists the received document categories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_received_document_categories_with_http_info(company_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListReceivedDocumentCategoriesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_received_document_categories" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListReceivedDocumentCategoriesResponse",
        }

        return self.api_client.call_api(
            "/c/{company_id}/info/received_document_categories",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_revenue_centers(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        **kwargs
    ) -> ListRevenueCentersResponse:  # noqa: E501
        """List Revenue Centers  # noqa: E501

        Lists the revenue centers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_revenue_centers(company_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListRevenueCentersResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_revenue_centers_with_http_info(
            company_id, **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_revenue_centers_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        **kwargs
    ):  # noqa: E501
        """List Revenue Centers  # noqa: E501

        Lists the revenue centers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_revenue_centers_with_http_info(company_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListRevenueCentersResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_revenue_centers" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListRevenueCentersResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/info/revenue_centers",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_templates(
        self,
        type: Annotated[
            Optional[StrictStr], Field(description="Type of the templates.")
        ] = None,
        by_type: Annotated[
            Optional[StrictBool],
            Field(
                description="[Only if type=all] If true, splits the list in objects, grouping templates by type."
            ),
        ] = None,
        **kwargs
    ) -> ListTemplatesResponse:  # noqa: E501
        """List Templates  # noqa: E501

        Lists the available templates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_templates(type, by_type, async_req=True)
        >>> result = thread.get()

        :param type: Type of the templates.
        :type type: str
        :param by_type: [Only if type=all] If true, splits the list in objects, grouping templates by type.
        :type by_type: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListTemplatesResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_templates_with_http_info(type, by_type, **kwargs)  # noqa: E501

    @validate_arguments
    def list_templates_with_http_info(
        self,
        type: Annotated[
            Optional[StrictStr], Field(description="Type of the templates.")
        ] = None,
        by_type: Annotated[
            Optional[StrictBool],
            Field(
                description="[Only if type=all] If true, splits the list in objects, grouping templates by type."
            ),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """List Templates  # noqa: E501

        Lists the available templates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_templates_with_http_info(type, by_type, async_req=True)
        >>> result = thread.get()

        :param type: Type of the templates.
        :type type: str
        :param by_type: [Only if type=all] If true, splits the list in objects, grouping templates by type.
        :type by_type: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListTemplatesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["type", "by_type"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_templates" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get("type") is not None:  # noqa: E501
            _query_params.append(("type", _params["type"]))

        if _params.get("by_type") is not None:  # noqa: E501
            _query_params.append(("by_type", _params["by_type"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListTemplatesResponse",
            "401": None,
        }

        return self.api_client.call_api(
            "/info/templates",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_units_of_measure(
        self, **kwargs
    ) -> ListUnitsOfMeasureResponse:  # noqa: E501
        """List Units of Measure  # noqa: E501

        Lists the units of measure.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_units_of_measure(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListUnitsOfMeasureResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_units_of_measure_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def list_units_of_measure_with_http_info(self, **kwargs):  # noqa: E501
        """List Units of Measure  # noqa: E501

        Lists the units of measure.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_units_of_measure_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListUnitsOfMeasureResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = []
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_units_of_measure" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListUnitsOfMeasureResponse",
            "401": None,
        }

        return self.api_client.call_api(
            "/info/measures",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_vat_types(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        **kwargs
    ) -> ListVatTypesResponse:  # noqa: E501
        """List Vat Types  # noqa: E501

        Lists the available vat types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_vat_types(company_id, fieldset, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListVatTypesResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_vat_types_with_http_info(
            company_id, fieldset, **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_vat_types_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """List Vat Types  # noqa: E501

        Lists the available vat types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_vat_types_with_http_info(company_id, fieldset, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListVatTypesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id", "fieldset"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_vat_types" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []
        if _params.get("fieldset") is not None:  # noqa: E501
            _query_params.append(("fieldset", _params["fieldset"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListVatTypesResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/info/vat_types",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
