# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.27
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from fattureincloud_python_sdk.models.company_type import CompanyType


class ControlledCompany(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    id: Optional[StrictInt] = Field(None, description="Company unique identifier.")
    name: Optional[StrictStr] = Field(None, description="Company name.")
    type: Optional[CompanyType] = None
    access_token: Optional[StrictStr] = Field(
        None,
        description="CompanyAuthentication token for this company. [Only if type=company]",
    )
    connection_id: Optional[StrictFloat] = Field(
        None, description="Company connection id."
    )
    tax_code: Optional[StrictStr] = Field(None, description="Tax code.")
    __properties = ["id", "name", "type", "access_token", "connection_id", "tax_code"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ControlledCompany:
        """Create an instance of ControlledCompany from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ControlledCompany:
        """Create an instance of ControlledCompany from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ControlledCompany.parse_obj(obj)

        _obj = ControlledCompany.parse_obj(
            {
                "id": obj.get("id") if obj.get("id") is not None else None,
                "name": obj.get("name") if obj.get("name") is not None else None,
                "type": obj.get("type"),
                "access_token": obj.get("access_token")
                if obj.get("access_token") is not None
                else None,
                "connection_id": float(obj.get("connection_id"))
                if obj.get("connection_id") is not None
                else None,
                "tax_code": obj.get("tax_code")
                if obj.get("tax_code") is not None
                else None,
            }
        )
        return _obj
