"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 400.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.9
    Contact: info@fattureincloud.it
    Generated by: https://openapi-generator.tech
"""


import json
import sys
import unittest
import datetime
import fattureincloud_python_sdk
from functions import json_serial
from functions import create_from_json
from fattureincloud_python_sdk.models.f24_status import F24Status
from fattureincloud_python_sdk.models.payment_account import PaymentAccount
from fattureincloud_python_sdk.models.payment_account_type import PaymentAccountType

globals()["F24Status"] = F24Status
globals()["PaymentAccount"] = PaymentAccount
from fattureincloud_python_sdk.models.f24 import F24


class TestF24(unittest.TestCase):
    """F24 unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testF24(self):
        """Test F24"""
        model = F24(
            id=1,
            due_date=datetime.datetime.strptime("2022-02-02", "%Y-%m-%d").date(),
            status=F24Status("paid"),
            payment_account=PaymentAccount(
                id=1,
                name="Conto Banca Intesa",
                type=PaymentAccountType("standard"),
                iban="iban_example",
                sia="sia_example",
                cuc="cuc_example",
                virtual=True,
            ),
            amount=300.0,
            attachment_token="attachment_token_example",
        )
        expected_json = '{"id": 1, "due_date": "2022-02-02", "status": "paid", "payment_account": {"id": 1, "name": "Conto Banca Intesa", "type": "standard", "iban": "iban_example", "sia": "sia_example", "cuc": "cuc_example", "virtual": true}, "amount": 300.0, "attachment_token": "attachment_token_example"}'
        actual_json = json.dumps(model.to_dict(), default=json_serial)
        assert actual_json == expected_json

        readonly_json = '{"due_date": "2022-02-02", "amount": 300.0, "description": "description_example", "id": 1, "status": "paid", "attachment_token": "attachment_token_example", "attachment_url": "spesa2.pdf"}'
        model = F24(
            id=1,
            due_date=datetime.datetime.strptime("2022-02-02", "%Y-%m-%d").date(),
            status=F24Status("paid"),
            amount=300.0,
            attachment_token="attachment_token_example",
            description="description_example",
            attachment_url="spesa2.pdf",
        )
        model = create_from_json(readonly_json, "F24")


if __name__ == "__main__":
    unittest.main()
