# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.28
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr

from typing import Optional

from fattureincloud_python_sdk.models.create_cashbook_entry_request import (
    CreateCashbookEntryRequest,
)
from fattureincloud_python_sdk.models.create_cashbook_entry_response import (
    CreateCashbookEntryResponse,
)
from fattureincloud_python_sdk.models.get_cashbook_entry_response import (
    GetCashbookEntryResponse,
)
from fattureincloud_python_sdk.models.list_cashbook_entries_response import (
    ListCashbookEntriesResponse,
)
from fattureincloud_python_sdk.models.modify_cashbook_entry_request import (
    ModifyCashbookEntryRequest,
)
from fattureincloud_python_sdk.models.modify_cashbook_entry_response import (
    ModifyCashbookEntryResponse,
)

from fattureincloud_python_sdk.api_client import ApiClient
from fattureincloud_python_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError,
)


class CashbookApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_cashbook_entry(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        create_cashbook_entry_request: Annotated[
            Optional[CreateCashbookEntryRequest], Field(description="Cashbook entry. ")
        ] = None,
        **kwargs
    ) -> CreateCashbookEntryResponse:  # noqa: E501
        """Create Cashbook Entry  # noqa: E501

        Creates a new cashbook entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cashbook_entry(company_id, create_cashbook_entry_request, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param create_cashbook_entry_request: Cashbook entry.
        :type create_cashbook_entry_request: CreateCashbookEntryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateCashbookEntryResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.create_cashbook_entry_with_http_info(
            company_id, create_cashbook_entry_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def create_cashbook_entry_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        create_cashbook_entry_request: Annotated[
            Optional[CreateCashbookEntryRequest], Field(description="Cashbook entry. ")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Create Cashbook Entry  # noqa: E501

        Creates a new cashbook entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cashbook_entry_with_http_info(company_id, create_cashbook_entry_request, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param create_cashbook_entry_request: Cashbook entry.
        :type create_cashbook_entry_request: CreateCashbookEntryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateCashbookEntryResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id", "create_cashbook_entry_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cashbook_entry" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["create_cashbook_entry_request"]:
            _body_params = _params["create_cashbook_entry_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "CreateCashbookEntryResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/cashbook",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def delete_cashbook_entry(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        document_id: Annotated[
            StrictStr, Field(..., description="The ID of the document.")
        ],
        **kwargs
    ) -> None:  # noqa: E501
        """Delete Cashbook Entry  # noqa: E501

        Deletes the specified cashbook entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_cashbook_entry(company_id, document_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param document_id: The ID of the document. (required)
        :type document_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_cashbook_entry_with_http_info(
            company_id, document_id, **kwargs
        )  # noqa: E501

    @validate_arguments
    def delete_cashbook_entry_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        document_id: Annotated[
            StrictStr, Field(..., description="The ID of the document.")
        ],
        **kwargs
    ):  # noqa: E501
        """Delete Cashbook Entry  # noqa: E501

        Deletes the specified cashbook entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_cashbook_entry_with_http_info(company_id, document_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param document_id: The ID of the document. (required)
        :type document_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = ["company_id", "document_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cashbook_entry" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        if _params["document_id"]:
            _path_params["document_id"] = _params["document_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            "/c/{company_id}/cashbook/{document_id}",
            "DELETE",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def get_cashbook_entry(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        document_id: Annotated[
            StrictStr, Field(..., description="The ID of the document.")
        ],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        **kwargs
    ) -> GetCashbookEntryResponse:  # noqa: E501
        """Get Cashbook Entry  # noqa: E501

        Gets the specified cashbook entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cashbook_entry(company_id, document_id, fields, fieldset, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param document_id: The ID of the document. (required)
        :type document_id: str
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetCashbookEntryResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.get_cashbook_entry_with_http_info(
            company_id, document_id, fields, fieldset, **kwargs
        )  # noqa: E501

    @validate_arguments
    def get_cashbook_entry_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        document_id: Annotated[
            StrictStr, Field(..., description="The ID of the document.")
        ],
        fields: Annotated[
            Optional[StrictStr], Field(description="List of comma-separated fields.")
        ] = None,
        fieldset: Annotated[
            Optional[StrictStr], Field(description="Name of the fieldset.")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Get Cashbook Entry  # noqa: E501

        Gets the specified cashbook entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cashbook_entry_with_http_info(company_id, document_id, fields, fieldset, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param document_id: The ID of the document. (required)
        :type document_id: str
        :param fields: List of comma-separated fields.
        :type fields: str
        :param fieldset: Name of the fieldset.
        :type fieldset: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetCashbookEntryResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id", "document_id", "fields", "fieldset"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cashbook_entry" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        if _params["document_id"]:
            _path_params["document_id"] = _params["document_id"]

        # process the query parameters
        _query_params = []
        if _params.get("fields") is not None:  # noqa: E501
            _query_params.append(("fields", _params["fields"]))

        if _params.get("fieldset") is not None:  # noqa: E501
            _query_params.append(("fieldset", _params["fieldset"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "GetCashbookEntryResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/cashbook/{document_id}",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def list_cashbook_entries(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        date_from: Annotated[StrictStr, Field(..., description="Start date.")],
        date_to: Annotated[StrictStr, Field(..., description="End date.")],
        year: Annotated[
            Optional[StrictInt], Field(description="Filter cashbook by year.")
        ] = None,
        type: Annotated[
            Optional[StrictStr], Field(description="Filter cashbook by type.")
        ] = None,
        payment_account_id: Annotated[
            Optional[StrictInt], Field(description="Filter by payment account.")
        ] = None,
        **kwargs
    ) -> ListCashbookEntriesResponse:  # noqa: E501
        """List Cashbook Entries  # noqa: E501

        Lists the cashbook entries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cashbook_entries(company_id, date_from, date_to, year, type, payment_account_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param date_from: Start date. (required)
        :type date_from: str
        :param date_to: End date. (required)
        :type date_to: str
        :param year: Filter cashbook by year.
        :type year: int
        :param type: Filter cashbook by type.
        :type type: str
        :param payment_account_id: Filter by payment account.
        :type payment_account_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListCashbookEntriesResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.list_cashbook_entries_with_http_info(
            company_id, date_from, date_to, year, type, payment_account_id, **kwargs
        )  # noqa: E501

    @validate_arguments
    def list_cashbook_entries_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        date_from: Annotated[StrictStr, Field(..., description="Start date.")],
        date_to: Annotated[StrictStr, Field(..., description="End date.")],
        year: Annotated[
            Optional[StrictInt], Field(description="Filter cashbook by year.")
        ] = None,
        type: Annotated[
            Optional[StrictStr], Field(description="Filter cashbook by type.")
        ] = None,
        payment_account_id: Annotated[
            Optional[StrictInt], Field(description="Filter by payment account.")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """List Cashbook Entries  # noqa: E501

        Lists the cashbook entries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cashbook_entries_with_http_info(company_id, date_from, date_to, year, type, payment_account_id, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param date_from: Start date. (required)
        :type date_from: str
        :param date_to: End date. (required)
        :type date_to: str
        :param year: Filter cashbook by year.
        :type year: int
        :param type: Filter cashbook by type.
        :type type: str
        :param payment_account_id: Filter by payment account.
        :type payment_account_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListCashbookEntriesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "company_id",
            "date_from",
            "date_to",
            "year",
            "type",
            "payment_account_id",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cashbook_entries" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        # process the query parameters
        _query_params = []
        if _params.get("date_from") is not None:  # noqa: E501
            _query_params.append(("date_from", _params["date_from"]))

        if _params.get("date_to") is not None:  # noqa: E501
            _query_params.append(("date_to", _params["date_to"]))

        if _params.get("year") is not None:  # noqa: E501
            _query_params.append(("year", _params["year"]))

        if _params.get("type") is not None:  # noqa: E501
            _query_params.append(("type", _params["type"]))

        if _params.get("payment_account_id") is not None:  # noqa: E501
            _query_params.append(("payment_account_id", _params["payment_account_id"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ListCashbookEntriesResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/cashbook",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def modify_cashbook_entry(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        document_id: Annotated[
            StrictStr, Field(..., description="The ID of the document.")
        ],
        modify_cashbook_entry_request: Annotated[
            Optional[ModifyCashbookEntryRequest], Field(description="Cashbook Entry")
        ] = None,
        **kwargs
    ) -> ModifyCashbookEntryResponse:  # noqa: E501
        """Modify Cashbook Entry  # noqa: E501

        Modifies the specified cashbook entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_cashbook_entry(company_id, document_id, modify_cashbook_entry_request, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param document_id: The ID of the document. (required)
        :type document_id: str
        :param modify_cashbook_entry_request: Cashbook Entry
        :type modify_cashbook_entry_request: ModifyCashbookEntryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ModifyCashbookEntryResponse
        """
        kwargs["_return_http_data_only"] = True
        return self.modify_cashbook_entry_with_http_info(
            company_id, document_id, modify_cashbook_entry_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def modify_cashbook_entry_with_http_info(
        self,
        company_id: Annotated[
            StrictInt, Field(..., description="The ID of the company.")
        ],
        document_id: Annotated[
            StrictStr, Field(..., description="The ID of the document.")
        ],
        modify_cashbook_entry_request: Annotated[
            Optional[ModifyCashbookEntryRequest], Field(description="Cashbook Entry")
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Modify Cashbook Entry  # noqa: E501

        Modifies the specified cashbook entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_cashbook_entry_with_http_info(company_id, document_id, modify_cashbook_entry_request, async_req=True)
        >>> result = thread.get()

        :param company_id: The ID of the company. (required)
        :type company_id: int
        :param document_id: The ID of the document. (required)
        :type document_id: str
        :param modify_cashbook_entry_request: Cashbook Entry
        :type modify_cashbook_entry_request: ModifyCashbookEntryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ModifyCashbookEntryResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["company_id", "document_id", "modify_cashbook_entry_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_cashbook_entry" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params["company_id"]:
            _path_params["company_id"] = _params["company_id"]

        if _params["document_id"]:
            _path_params["document_id"] = _params["document_id"]

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params["modify_cashbook_entry_request"]:
            _body_params = _params["modify_cashbook_entry_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["OAuth2AuthenticationCodeFlow"]  # noqa: E501

        _response_types_map = {
            "200": "ModifyCashbookEntryResponse",
            "401": None,
            "404": None,
        }

        return self.api_client.call_api(
            "/c/{company_id}/cashbook/{document_id}",
            "PUT",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
