# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.28
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Optional
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from fattureincloud_python_sdk.models.f24_status import F24Status
from fattureincloud_python_sdk.models.payment_account import PaymentAccount


class F24(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    id: Optional[StrictInt] = Field(None, description="Unique F24 identifier.")
    due_date: Optional[date] = Field(None, description="Due date.")
    status: Optional[F24Status] = None
    payment_account: Optional[PaymentAccount] = None
    amount: Optional[StrictFloat] = Field(None, description="Taxes amount.")
    attachment_url: Optional[StrictStr] = Field(
        None,
        description="[Temporary] [Read Only] Absolute url of the attached file. Authomatically set if a valid attachment token is passed via POST /taxes or PUT /taxes/{documentId}.",
    )
    attachment_token: Optional[StrictStr] = Field(
        None,
        description="[Write Only] Attachment token returned by POST /taxes/attachment. Used to attach the file already uploaded.",
    )
    description: Optional[StrictStr] = Field(
        None, description="Name or brief description."
    )
    __properties = [
        "id",
        "due_date",
        "status",
        "payment_account",
        "amount",
        "attachment_url",
        "attachment_token",
        "description",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> F24:
        """Create an instance of F24 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "attachment_url",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of payment_account
        if self.payment_account:
            _dict["payment_account"] = self.payment_account.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> F24:
        """Create an instance of F24 from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return F24.parse_obj(obj)

        _obj = F24.parse_obj(
            {
                "id": obj.get("id") if obj.get("id") is not None else None,
                "due_date": obj.get("due_date")
                if obj.get("due_date") is not None
                else None,
                "status": obj.get("status"),
                "payment_account": PaymentAccount.from_dict(obj.get("payment_account"))
                if obj.get("payment_account") is not None
                else None,
                "amount": float(obj.get("amount"))
                if obj.get("amount") is not None
                else None,
                "attachment_url": obj.get("attachment_url")
                if obj.get("attachment_url") is not None
                else None,
                "attachment_token": obj.get("attachment_token")
                if obj.get("attachment_token") is not None
                else None,
                "description": obj.get("description")
                if obj.get("description") is not None
                else None,
            }
        )
        return _obj
