# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.28
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from fattureincloud_python_sdk.models.original_document_type import OriginalDocumentType
from fattureincloud_python_sdk.models.vat_kind import VatKind


class IssuedDocumentEiData(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    vat_kind: Optional[VatKind] = None
    original_document_type: Optional[OriginalDocumentType] = None
    od_number: Optional[StrictStr] = Field(
        None, description="Original document number."
    )
    od_date: Optional[date] = Field(None, description="Original document date.")
    cig: Optional[StrictStr] = Field(None, description="CIG.")
    cup: Optional[StrictStr] = Field(None, description="CUP.")
    payment_method: Optional[StrictStr] = Field(
        None,
        description="Payment method (see https://www.fatturapa.gov.it/export/documenti/fatturapa/v1.2.1/Rappresentazione-tabellare-fattura-ordinaria.pdf for the accepted values of ModalitaPagamento).",
    )
    bank_name: Optional[StrictStr] = Field(None, description="Bank name.")
    bank_iban: Optional[StrictStr] = Field(None, description="IBAN.")
    bank_beneficiary: Optional[StrictStr] = Field(None, description="Bank beneficiary.")
    invoice_number: Optional[StrictStr] = Field(None, description="Invoice number.")
    invoice_date: Optional[date] = Field(None, description="Invoice date.")
    __properties = [
        "vat_kind",
        "original_document_type",
        "od_number",
        "od_date",
        "cig",
        "cup",
        "payment_method",
        "bank_name",
        "bank_iban",
        "bank_beneficiary",
        "invoice_number",
        "invoice_date",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IssuedDocumentEiData:
        """Create an instance of IssuedDocumentEiData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IssuedDocumentEiData:
        """Create an instance of IssuedDocumentEiData from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return IssuedDocumentEiData.parse_obj(obj)

        _obj = IssuedDocumentEiData.parse_obj(
            {
                "vat_kind": obj.get("vat_kind"),
                "original_document_type": obj.get("original_document_type"),
                "od_number": obj.get("od_number")
                if obj.get("od_number") is not None
                else None,
                "od_date": obj.get("od_date")
                if obj.get("od_date") is not None
                else None,
                "cig": obj.get("cig") if obj.get("cig") is not None else None,
                "cup": obj.get("cup") if obj.get("cup") is not None else None,
                "payment_method": obj.get("payment_method")
                if obj.get("payment_method") is not None
                else None,
                "bank_name": obj.get("bank_name")
                if obj.get("bank_name") is not None
                else None,
                "bank_iban": obj.get("bank_iban")
                if obj.get("bank_iban") is not None
                else None,
                "bank_beneficiary": obj.get("bank_beneficiary")
                if obj.get("bank_beneficiary") is not None
                else None,
                "invoice_number": obj.get("invoice_number")
                if obj.get("invoice_number") is not None
                else None,
                "invoice_date": obj.get("invoice_date")
                if obj.get("invoice_date") is not None
                else None,
            }
        )
        return _obj
