# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.28
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from fattureincloud_python_sdk.models.currency import Currency
from fattureincloud_python_sdk.models.document_template import DocumentTemplate
from fattureincloud_python_sdk.models.issued_document_pre_create_info_default_values import (
    IssuedDocumentPreCreateInfoDefaultValues,
)
from fattureincloud_python_sdk.models.issued_document_pre_create_info_extra_data_default_values import (
    IssuedDocumentPreCreateInfoExtraDataDefaultValues,
)
from fattureincloud_python_sdk.models.issued_document_pre_create_info_items_default_values import (
    IssuedDocumentPreCreateInfoItemsDefaultValues,
)
from fattureincloud_python_sdk.models.language import Language
from fattureincloud_python_sdk.models.payment_account import PaymentAccount
from fattureincloud_python_sdk.models.payment_method import PaymentMethod
from fattureincloud_python_sdk.models.vat_type import VatType


class IssuedDocumentPreCreateInfo(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    numerations: Optional[Dict[str, Dict[str, StrictInt]]] = None
    dn_numerations: Optional[Dict[str, Dict[str, StrictInt]]] = None
    default_values: Optional[IssuedDocumentPreCreateInfoDefaultValues] = None
    extra_data_default_values: Optional[
        IssuedDocumentPreCreateInfoExtraDataDefaultValues
    ] = None
    items_default_values: Optional[IssuedDocumentPreCreateInfoItemsDefaultValues] = None
    countries_list: Optional[conlist(StrictStr)] = Field(
        None, description="Countries list."
    )
    currencies_list: Optional[conlist(Currency)] = Field(
        None, description="Currencies list."
    )
    templates_list: Optional[conlist(DocumentTemplate)] = Field(
        None, description="Document templates list."
    )
    dn_templates_list: Optional[conlist(DocumentTemplate)] = Field(
        None, description="Delivery note templates list."
    )
    ai_templates_list: Optional[conlist(DocumentTemplate)] = Field(
        None, description="Accompanying invoice templates list."
    )
    payment_methods_list: Optional[conlist(PaymentMethod)] = Field(
        None, description="Payment methods list."
    )
    payment_accounts_list: Optional[conlist(PaymentAccount)] = Field(
        None, description="Payment accounts list."
    )
    vat_types_list: Optional[conlist(VatType)] = Field(
        None, description="Vat types list."
    )
    languages_list: Optional[conlist(Language)] = Field(
        None, description="Languages list."
    )
    __properties = [
        "numerations",
        "dn_numerations",
        "default_values",
        "extra_data_default_values",
        "items_default_values",
        "countries_list",
        "currencies_list",
        "templates_list",
        "dn_templates_list",
        "ai_templates_list",
        "payment_methods_list",
        "payment_accounts_list",
        "vat_types_list",
        "languages_list",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IssuedDocumentPreCreateInfo:
        """Create an instance of IssuedDocumentPreCreateInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of default_values
        if self.default_values:
            _dict["default_values"] = self.default_values.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extra_data_default_values
        if self.extra_data_default_values:
            _dict[
                "extra_data_default_values"
            ] = self.extra_data_default_values.to_dict()
        # override the default output from pydantic by calling `to_dict()` of items_default_values
        if self.items_default_values:
            _dict["items_default_values"] = self.items_default_values.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in currencies_list (list)
        _items = []
        if self.currencies_list:
            for _item in self.currencies_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["currencies_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in templates_list (list)
        _items = []
        if self.templates_list:
            for _item in self.templates_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["templates_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in dn_templates_list (list)
        _items = []
        if self.dn_templates_list:
            for _item in self.dn_templates_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["dn_templates_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ai_templates_list (list)
        _items = []
        if self.ai_templates_list:
            for _item in self.ai_templates_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["ai_templates_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payment_methods_list (list)
        _items = []
        if self.payment_methods_list:
            for _item in self.payment_methods_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["payment_methods_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payment_accounts_list (list)
        _items = []
        if self.payment_accounts_list:
            for _item in self.payment_accounts_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["payment_accounts_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vat_types_list (list)
        _items = []
        if self.vat_types_list:
            for _item in self.vat_types_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["vat_types_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in languages_list (list)
        _items = []
        if self.languages_list:
            for _item in self.languages_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["languages_list"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IssuedDocumentPreCreateInfo:
        """Create an instance of IssuedDocumentPreCreateInfo from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return IssuedDocumentPreCreateInfo.parse_obj(obj)

        _obj = IssuedDocumentPreCreateInfo.parse_obj(
            {
                "numerations": obj.get("numerations"),
                "dn_numerations": obj.get("dn_numerations"),
                "default_values": IssuedDocumentPreCreateInfoDefaultValues.from_dict(
                    obj.get("default_values")
                )
                if obj.get("default_values") is not None
                else None,
                "extra_data_default_values": IssuedDocumentPreCreateInfoExtraDataDefaultValues.from_dict(
                    obj.get("extra_data_default_values")
                )
                if obj.get("extra_data_default_values") is not None
                else None,
                "items_default_values": IssuedDocumentPreCreateInfoItemsDefaultValues.from_dict(
                    obj.get("items_default_values")
                )
                if obj.get("items_default_values") is not None
                else None,
                "countries_list": obj.get("countries_list"),
                "currencies_list": [
                    Currency.from_dict(_item) for _item in obj.get("currencies_list")
                ]
                if obj.get("currencies_list") is not None
                else None,
                "templates_list": [
                    DocumentTemplate.from_dict(_item)
                    for _item in obj.get("templates_list")
                ]
                if obj.get("templates_list") is not None
                else None,
                "dn_templates_list": [
                    DocumentTemplate.from_dict(_item)
                    for _item in obj.get("dn_templates_list")
                ]
                if obj.get("dn_templates_list") is not None
                else None,
                "ai_templates_list": [
                    DocumentTemplate.from_dict(_item)
                    for _item in obj.get("ai_templates_list")
                ]
                if obj.get("ai_templates_list") is not None
                else None,
                "payment_methods_list": [
                    PaymentMethod.from_dict(_item)
                    for _item in obj.get("payment_methods_list")
                ]
                if obj.get("payment_methods_list") is not None
                else None,
                "payment_accounts_list": [
                    PaymentAccount.from_dict(_item)
                    for _item in obj.get("payment_accounts_list")
                ]
                if obj.get("payment_accounts_list") is not None
                else None,
                "vat_types_list": [
                    VatType.from_dict(_item) for _item in obj.get("vat_types_list")
                ]
                if obj.get("vat_types_list") is not None
                else None,
                "languages_list": [
                    Language.from_dict(_item) for _item in obj.get("languages_list")
                ]
                if obj.get("languages_list") is not None
                else None,
            }
        )
        return _obj
