# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.28
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictStr
from fattureincloud_python_sdk.models.document_template import DocumentTemplate
from fattureincloud_python_sdk.models.payment_method import PaymentMethod


class IssuedDocumentPreCreateInfoDefaultValues(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    default_template: Optional[DocumentTemplate] = None
    dn_template: Optional[DocumentTemplate] = None
    ai_template: Optional[DocumentTemplate] = None
    notes: Optional[StrictStr] = Field(None, description="Default notes.")
    rivalsa: Optional[StrictFloat] = Field(
        None, description="Default rivalsa percentage."
    )
    cassa: Optional[StrictFloat] = Field(None, description="Default cassa percentage.")
    withholding_tax: Optional[StrictFloat] = Field(
        None, description="Default withholding tax percentage."
    )
    withholding_tax_taxable: Optional[StrictFloat] = Field(
        None, description="Default withholding tax taxable percentage."
    )
    other_withholding_tax: Optional[StrictFloat] = Field(
        None, description="Default other withholding tax percentage."
    )
    use_gross_prices: Optional[StrictBool] = Field(
        None, description="Use gross price by default."
    )
    payment_method: Optional[PaymentMethod] = None
    __properties = [
        "default_template",
        "dn_template",
        "ai_template",
        "notes",
        "rivalsa",
        "cassa",
        "withholding_tax",
        "withholding_tax_taxable",
        "other_withholding_tax",
        "use_gross_prices",
        "payment_method",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IssuedDocumentPreCreateInfoDefaultValues:
        """Create an instance of IssuedDocumentPreCreateInfoDefaultValues from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of default_template
        if self.default_template:
            _dict["default_template"] = self.default_template.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dn_template
        if self.dn_template:
            _dict["dn_template"] = self.dn_template.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ai_template
        if self.ai_template:
            _dict["ai_template"] = self.ai_template.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payment_method
        if self.payment_method:
            _dict["payment_method"] = self.payment_method.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IssuedDocumentPreCreateInfoDefaultValues:
        """Create an instance of IssuedDocumentPreCreateInfoDefaultValues from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return IssuedDocumentPreCreateInfoDefaultValues.parse_obj(obj)

        _obj = IssuedDocumentPreCreateInfoDefaultValues.parse_obj(
            {
                "default_template": DocumentTemplate.from_dict(
                    obj.get("default_template")
                )
                if obj.get("default_template") is not None
                else None,
                "dn_template": DocumentTemplate.from_dict(obj.get("dn_template"))
                if obj.get("dn_template") is not None
                else None,
                "ai_template": DocumentTemplate.from_dict(obj.get("ai_template"))
                if obj.get("ai_template") is not None
                else None,
                "notes": obj.get("notes") if obj.get("notes") is not None else None,
                "rivalsa": float(obj.get("rivalsa"))
                if obj.get("rivalsa") is not None
                else None,
                "cassa": float(obj.get("cassa"))
                if obj.get("cassa") is not None
                else None,
                "withholding_tax": float(obj.get("withholding_tax"))
                if obj.get("withholding_tax") is not None
                else None,
                "withholding_tax_taxable": float(obj.get("withholding_tax_taxable"))
                if obj.get("withholding_tax_taxable") is not None
                else None,
                "other_withholding_tax": float(obj.get("other_withholding_tax"))
                if obj.get("other_withholding_tax") is not None
                else None,
                "use_gross_prices": obj.get("use_gross_prices")
                if obj.get("use_gross_prices") is not None
                else None,
                "payment_method": PaymentMethod.from_dict(obj.get("payment_method"))
                if obj.get("payment_method") is not None
                else None,
            }
        )
        return _obj
