# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.0.30
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel
from fattureincloud_python_sdk.models.company_info_plan_info_functions import (
    CompanyInfoPlanInfoFunctions,
)
from fattureincloud_python_sdk.models.company_info_plan_info_functions_status import (
    CompanyInfoPlanInfoFunctionsStatus,
)
from fattureincloud_python_sdk.models.company_info_plan_info_limits import (
    CompanyInfoPlanInfoLimits,
)


class CompanyInfoPlanInfo(BaseModel):
    """
    Company plan info # noqa: E501
    """

    limits: Optional[CompanyInfoPlanInfoLimits] = None
    functions: Optional[CompanyInfoPlanInfoFunctions] = None
    functions_status: Optional[CompanyInfoPlanInfoFunctionsStatus] = None
    __properties = ["limits", "functions", "functions_status"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompanyInfoPlanInfo:
        """Create an instance of CompanyInfoPlanInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of limits
        if self.limits:
            _dict["limits"] = self.limits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of functions
        if self.functions:
            _dict["functions"] = self.functions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of functions_status
        if self.functions_status:
            _dict["functions_status"] = self.functions_status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CompanyInfoPlanInfo:
        """Create an instance of CompanyInfoPlanInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CompanyInfoPlanInfo.parse_obj(obj)

        _obj = CompanyInfoPlanInfo.parse_obj(
            {
                "limits": CompanyInfoPlanInfoLimits.from_dict(obj.get("limits"))
                if obj.get("limits") is not None
                else None,
                "functions": CompanyInfoPlanInfoFunctions.from_dict(
                    obj.get("functions")
                )
                if obj.get("functions") is not None
                else None,
                "functions_status": CompanyInfoPlanInfoFunctionsStatus.from_dict(
                    obj.get("functions_status")
                )
                if obj.get("functions_status") is not None
                else None,
            }
        )
        return _obj
