# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.0.30
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr


class EInvoiceRejectionReason(BaseModel):
    """
    EInvoiceRejectionReason
    """

    reason: Optional[StrictStr] = Field(None, description="E-invoice rejection reason")
    ei_status: Optional[StrictStr] = Field(None, description="E-invoice status")
    solution: Optional[StrictStr] = Field(None, description="Error solution.")
    code: Optional[StrictStr] = Field(
        None, description="E-invoice rejection error code"
    )
    var_date: Optional[datetime] = Field(
        None, alias="date", description="E-invoice rejection date"
    )
    __properties = ["reason", "ei_status", "solution", "code", "date"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EInvoiceRejectionReason:
        """Create an instance of EInvoiceRejectionReason from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EInvoiceRejectionReason:
        """Create an instance of EInvoiceRejectionReason from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EInvoiceRejectionReason.parse_obj(obj)

        _obj = EInvoiceRejectionReason.parse_obj(
            {
                "reason": obj.get("reason") if obj.get("reason") is not None else None,
                "ei_status": obj.get("ei_status")
                if obj.get("ei_status") is not None
                else None,
                "solution": obj.get("solution")
                if obj.get("solution") is not None
                else None,
                "code": obj.get("code") if obj.get("code") is not None else None,
                "var_date": obj.get("date") if obj.get("date") is not None else None,
            }
        )
        return _obj
