# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.0.30
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from fattureincloud_python_sdk.models.email_data_default_sender_email import (
    EmailDataDefaultSenderEmail,
)
from fattureincloud_python_sdk.models.sender_email import SenderEmail


class EmailData(BaseModel):
    """
    EmailData
    """

    recipient_email: Optional[StrictStr] = Field(None, description="Email recipient")
    default_sender_email: Optional[EmailDataDefaultSenderEmail] = None
    sender_emails_list: Optional[conlist(SenderEmail)] = Field(
        None, description="List of all emails from which the document can be sent"
    )
    cc_email: Optional[StrictStr] = Field(
        None, description="Email cc [by default is the logged company email]"
    )
    subject: Optional[StrictStr] = Field(None, description="Email subject")
    body: Optional[StrictStr] = Field(None, description="Email body")
    document_exists: Optional[StrictBool] = Field(
        None, description="Document exists if it is not a delivery note"
    )
    delivery_note_exists: Optional[StrictBool] = Field(
        None, description="Document is a delivery note"
    )
    attachment_exists: Optional[StrictBool] = Field(
        None, description="Document has attachment"
    )
    accompanying_invoice_exists: Optional[StrictBool] = Field(
        None, description="Document has accompanying invoice"
    )
    default_attach_pdf: Optional[StrictBool] = Field(
        None, description="Attach document pdf"
    )
    __properties = [
        "recipient_email",
        "default_sender_email",
        "sender_emails_list",
        "cc_email",
        "subject",
        "body",
        "document_exists",
        "delivery_note_exists",
        "attachment_exists",
        "accompanying_invoice_exists",
        "default_attach_pdf",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EmailData:
        """Create an instance of EmailData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of default_sender_email
        if self.default_sender_email:
            _dict["default_sender_email"] = self.default_sender_email.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sender_emails_list (list)
        _items = []
        if self.sender_emails_list:
            for _item in self.sender_emails_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["sender_emails_list"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EmailData:
        """Create an instance of EmailData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EmailData.parse_obj(obj)

        _obj = EmailData.parse_obj(
            {
                "recipient_email": obj.get("recipient_email")
                if obj.get("recipient_email") is not None
                else None,
                "default_sender_email": EmailDataDefaultSenderEmail.from_dict(
                    obj.get("default_sender_email")
                )
                if obj.get("default_sender_email") is not None
                else None,
                "sender_emails_list": [
                    SenderEmail.from_dict(_item)
                    for _item in obj.get("sender_emails_list")
                ]
                if obj.get("sender_emails_list") is not None
                else None,
                "cc_email": obj.get("cc_email")
                if obj.get("cc_email") is not None
                else None,
                "subject": obj.get("subject")
                if obj.get("subject") is not None
                else None,
                "body": obj.get("body") if obj.get("body") is not None else None,
                "document_exists": obj.get("document_exists")
                if obj.get("document_exists") is not None
                else None,
                "delivery_note_exists": obj.get("delivery_note_exists")
                if obj.get("delivery_note_exists") is not None
                else None,
                "attachment_exists": obj.get("attachment_exists")
                if obj.get("attachment_exists") is not None
                else None,
                "accompanying_invoice_exists": obj.get("accompanying_invoice_exists")
                if obj.get("accompanying_invoice_exists") is not None
                else None,
                "default_attach_pdf": obj.get("default_attach_pdf")
                if obj.get("default_attach_pdf") is not None
                else None,
            }
        )
        return _obj
