# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.0.30
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist


class IssuedDocumentOptions(BaseModel):
    """
    IssuedDocumentOptions
    """

    fix_payments: Optional[StrictBool] = Field(
        None, description="Fixes your last payment amount to match your document total"
    )
    create_from: Optional[conlist(StrictStr)] = Field(
        None, description="Original documents ids [only for join/transform]"
    )
    transform: Optional[StrictBool] = Field(
        None, description="Tranform a document [only for transform]"
    )
    keep_copy: Optional[StrictBool] = Field(
        None, description="Keep original document [only for transform]"
    )
    join_type: Optional[StrictStr] = Field(
        None, description="Join type [only for join]"
    )
    __properties = [
        "fix_payments",
        "create_from",
        "transform",
        "keep_copy",
        "join_type",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IssuedDocumentOptions:
        """Create an instance of IssuedDocumentOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IssuedDocumentOptions:
        """Create an instance of IssuedDocumentOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IssuedDocumentOptions.parse_obj(obj)

        _obj = IssuedDocumentOptions.parse_obj(
            {
                "fix_payments": obj.get("fix_payments")
                if obj.get("fix_payments") is not None
                else None,
                "create_from": obj.get("create_from"),
                "transform": obj.get("transform")
                if obj.get("transform") is not None
                else None,
                "keep_copy": obj.get("keep_copy")
                if obj.get("keep_copy") is not None
                else None,
                "join_type": obj.get("join_type")
                if obj.get("join_type") is not None
                else None,
            }
        )
        return _obj
