# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.0.30
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import List, Optional, Union
from pydantic import (
    BaseModel,
    Field,
    StrictBool,
    StrictFloat,
    StrictInt,
    StrictStr,
    conlist,
)
from fattureincloud_python_sdk.models.currency import Currency
from fattureincloud_python_sdk.models.entity import Entity
from fattureincloud_python_sdk.models.received_document_items_list_item import (
    ReceivedDocumentItemsListItem,
)
from fattureincloud_python_sdk.models.received_document_payments_list_item import (
    ReceivedDocumentPaymentsListItem,
)
from fattureincloud_python_sdk.models.received_document_type import ReceivedDocumentType


class ReceivedDocument(BaseModel):
    """
    ReceivedDocument
    """

    id: Optional[StrictInt] = Field(None, description="Received document id")
    type: Optional[ReceivedDocumentType] = None
    entity: Optional[Entity] = None
    var_date: Optional[date] = Field(
        None,
        alias="date",
        description="Received document date [defaults to today's date]",
    )
    category: Optional[StrictStr] = Field(
        None, description="Received document category"
    )
    description: Optional[StrictStr] = Field(
        None, description="Received document description"
    )
    amount_net: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, description="Received document total net amount"
    )
    amount_vat: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, description="Received document total vat amount"
    )
    amount_withholding_tax: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, description="Received document withholding tax amount"
    )
    amount_other_withholding_tax: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, description="Received document other withholding tax amount"
    )
    amount_gross: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, description="[Read Only] Received document total gross amount"
    )
    amortization: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, description="Received document amortization value"
    )
    rc_center: Optional[StrictStr] = Field(
        None, description="Received document revenue center"
    )
    invoice_number: Optional[StrictStr] = Field(
        None, description="Received document invoice number"
    )
    is_marked: Optional[StrictBool] = Field(
        None, description="Received document is marked"
    )
    is_detailed: Optional[StrictBool] = Field(
        None, description="Received document has items"
    )
    e_invoice: Optional[StrictBool] = Field(
        None, description="[Read Only] Received document is an e-invoice"
    )
    next_due_date: Optional[date] = Field(
        None,
        description="[Read Only] Received document date of the next not paid payment",
    )
    currency: Optional[Currency] = None
    tax_deductibility: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, description="Received document tax deducibility percentage"
    )
    vat_deductibility: Optional[Union[StrictFloat, StrictInt]] = Field(
        None, description="Received document vat deducibility percentage"
    )
    items_list: Optional[conlist(ReceivedDocumentItemsListItem)] = None
    payments_list: Optional[conlist(ReceivedDocumentPaymentsListItem)] = None
    attachment_url: Optional[StrictStr] = Field(
        None,
        description="[Temporary] [Read Only] Received document url of the attached file",
    )
    attachment_preview_url: Optional[StrictStr] = Field(
        None,
        description="[Temporary] [Read Only] Received document url of the attachment preview",
    )
    auto_calculate: Optional[StrictBool] = Field(
        None,
        description="Received document total items amount and total payments amount can differ if this field is set to false",
    )
    attachment_token: Optional[StrictStr] = Field(
        None,
        description="[Write Only] Received document attachment token returned by POST /received_documents/attachment",
    )
    locked: Optional[StrictBool] = Field(
        None, description="Received Document can't be edited"
    )
    created_at: Optional[StrictStr] = Field(
        None, description="Received document creation date"
    )
    updated_at: Optional[StrictStr] = Field(
        None, description="Received document last update date"
    )
    __properties = [
        "id",
        "type",
        "entity",
        "date",
        "category",
        "description",
        "amount_net",
        "amount_vat",
        "amount_withholding_tax",
        "amount_other_withholding_tax",
        "amount_gross",
        "amortization",
        "rc_center",
        "invoice_number",
        "is_marked",
        "is_detailed",
        "e_invoice",
        "next_due_date",
        "currency",
        "tax_deductibility",
        "vat_deductibility",
        "items_list",
        "payments_list",
        "attachment_url",
        "attachment_preview_url",
        "auto_calculate",
        "attachment_token",
        "locked",
        "created_at",
        "updated_at",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReceivedDocument:
        """Create an instance of ReceivedDocument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "amount_gross",
                "next_due_date",
                "attachment_url",
                "attachment_preview_url",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict["entity"] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of currency
        if self.currency:
            _dict["currency"] = self.currency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items_list (list)
        _items = []
        if self.items_list:
            for _item in self.items_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["items_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payments_list (list)
        _items = []
        if self.payments_list:
            for _item in self.payments_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict["payments_list"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReceivedDocument:
        """Create an instance of ReceivedDocument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReceivedDocument.parse_obj(obj)

        _obj = ReceivedDocument.parse_obj(
            {
                "id": obj.get("id") if obj.get("id") is not None else None,
                "type": obj.get("type"),
                "entity": Entity.from_dict(obj.get("entity"))
                if obj.get("entity") is not None
                else None,
                "var_date": obj.get("date") if obj.get("date") is not None else None,
                "category": obj.get("category")
                if obj.get("category") is not None
                else None,
                "description": obj.get("description")
                if obj.get("description") is not None
                else None,
                "amount_net": float(obj.get("amount_net"))
                if obj.get("amount_net") is not None
                else None,
                "amount_vat": float(obj.get("amount_vat"))
                if obj.get("amount_vat") is not None
                else None,
                "amount_withholding_tax": float(obj.get("amount_withholding_tax"))
                if obj.get("amount_withholding_tax") is not None
                else None,
                "amount_other_withholding_tax": float(
                    obj.get("amount_other_withholding_tax")
                )
                if obj.get("amount_other_withholding_tax") is not None
                else None,
                "amount_gross": float(obj.get("amount_gross"))
                if obj.get("amount_gross") is not None
                else None,
                "amortization": float(obj.get("amortization"))
                if obj.get("amortization") is not None
                else None,
                "rc_center": obj.get("rc_center")
                if obj.get("rc_center") is not None
                else None,
                "invoice_number": obj.get("invoice_number")
                if obj.get("invoice_number") is not None
                else None,
                "is_marked": obj.get("is_marked")
                if obj.get("is_marked") is not None
                else None,
                "is_detailed": obj.get("is_detailed")
                if obj.get("is_detailed") is not None
                else None,
                "e_invoice": obj.get("e_invoice")
                if obj.get("e_invoice") is not None
                else None,
                "next_due_date": obj.get("next_due_date")
                if obj.get("next_due_date") is not None
                else None,
                "currency": Currency.from_dict(obj.get("currency"))
                if obj.get("currency") is not None
                else None,
                "tax_deductibility": float(obj.get("tax_deductibility"))
                if obj.get("tax_deductibility") is not None
                else None,
                "vat_deductibility": float(obj.get("vat_deductibility"))
                if obj.get("vat_deductibility") is not None
                else None,
                "items_list": [
                    ReceivedDocumentItemsListItem.from_dict(_item)
                    for _item in obj.get("items_list")
                ]
                if obj.get("items_list") is not None
                else None,
                "payments_list": [
                    ReceivedDocumentPaymentsListItem.from_dict(_item)
                    for _item in obj.get("payments_list")
                ]
                if obj.get("payments_list") is not None
                else None,
                "attachment_url": obj.get("attachment_url")
                if obj.get("attachment_url") is not None
                else None,
                "attachment_preview_url": obj.get("attachment_preview_url")
                if obj.get("attachment_preview_url") is not None
                else None,
                "auto_calculate": obj.get("auto_calculate")
                if obj.get("auto_calculate") is not None
                else None,
                "attachment_token": obj.get("attachment_token")
                if obj.get("attachment_token") is not None
                else None,
                "locked": obj.get("locked") if obj.get("locked") is not None else None,
                "created_at": obj.get("created_at")
                if obj.get("created_at") is not None
                else None,
                "updated_at": obj.get("updated_at")
                if obj.get("updated_at") is not None
                else None,
            }
        )
        return _obj
