# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.0.30
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr


class SendEInvoiceRequestData(BaseModel):
    """
    SendEInvoiceRequestData
    """

    cassa_type: Optional[StrictStr] = Field(
        None,
        description="Value of TipoCassa used (optional, override the company default value).",
    )
    withholding_tax_causal: Optional[StrictStr] = Field(
        None,
        description="Value of CausalePagamento used (optional, override the company default value).",
    )
    __properties = ["cassa_type", "withholding_tax_causal"]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SendEInvoiceRequestData:
        """Create an instance of SendEInvoiceRequestData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SendEInvoiceRequestData:
        """Create an instance of SendEInvoiceRequestData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SendEInvoiceRequestData.parse_obj(obj)

        _obj = SendEInvoiceRequestData.parse_obj(
            {
                "cassa_type": obj.get("cassa_type")
                if obj.get("cassa_type") is not None
                else None,
                "withholding_tax_causal": obj.get("withholding_tax_causal")
                if obj.get("withholding_tax_causal") is not None
                else None,
            }
        )
        return _obj
