"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 400.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.9
    Contact: info@fattureincloud.it
    Generated by: https://openapi-generator.tech
"""


import unittest

import fattureincloud_python_sdk
from fattureincloud_python_sdk.rest import RESTResponse
import functions
from fattureincloud_python_sdk.api.info_api import InfoApi
from fattureincloud_python_sdk.models.city import City
from fattureincloud_python_sdk.models.currency import Currency
from fattureincloud_python_sdk.models.document_template import DocumentTemplate
from fattureincloud_python_sdk.models.language import Language
from fattureincloud_python_sdk.models.list_archive_categories_response import (
    ListArchiveCategoriesResponse,
)
from fattureincloud_python_sdk.models.list_cities_response import ListCitiesResponse
from fattureincloud_python_sdk.models.detailed_country import DetailedCountry
from fattureincloud_python_sdk.models.list_detailed_countries_response import (
    ListDetailedCountriesResponse,
)
from fattureincloud_python_sdk.models.list_cost_centers_response import (
    ListCostCentersResponse,
)
from fattureincloud_python_sdk.models.list_countries_response import (
    ListCountriesResponse,
)
from fattureincloud_python_sdk.models.list_currencies_response import (
    ListCurrenciesResponse,
)
from fattureincloud_python_sdk.models.list_delivery_notes_default_causals_response import (
    ListDeliveryNotesDefaultCausalsResponse,
)
from fattureincloud_python_sdk.models.list_languages_response import (
    ListLanguagesResponse,
)
from fattureincloud_python_sdk.models.list_payment_accounts_response import (
    ListPaymentAccountsResponse,
)
from fattureincloud_python_sdk.models.list_payment_methods_response import (
    ListPaymentMethodsResponse,
)
from fattureincloud_python_sdk.models.list_product_categories_response import (
    ListProductCategoriesResponse,
)
from fattureincloud_python_sdk.models.list_received_document_categories_response import (
    ListReceivedDocumentCategoriesResponse,
)
from fattureincloud_python_sdk.models.list_revenue_centers_response import (
    ListRevenueCentersResponse,
)
from fattureincloud_python_sdk.models.list_templates_response import (
    ListTemplatesResponse,
)
from fattureincloud_python_sdk.models.list_units_of_measure_response import (
    ListUnitsOfMeasureResponse,
)
from fattureincloud_python_sdk.models.list_vat_types_response import (
    ListVatTypesResponse,
)
from fattureincloud_python_sdk.models.payment_account import PaymentAccount
from fattureincloud_python_sdk.models.payment_account_type import PaymentAccountType
from fattureincloud_python_sdk.models.payment_method import PaymentMethod
from fattureincloud_python_sdk.models.payment_method_details import PaymentMethodDetails
from fattureincloud_python_sdk.models.payment_method_type import PaymentMethodType
from fattureincloud_python_sdk.models.vat_type import VatType


class TestInfoApi(unittest.TestCase):
    """InfoApi unit test stubs"""

    def setUp(self):
        self.api = InfoApi()

    def tearDown(self):
        pass

    def test_list_archive_categories(self):
        resp = {"status": 200, "data": b'{"data":["cat5", "cat6"]}', "reason": "OK"}

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListArchiveCategoriesResponse(data=["cat7", "cat6"])
        actual = self.api.list_archive_categories(2)
        actual.data[0] = "cat7"
        assert actual == expected

    def test_list_cities(self):
        resp = {
            "status": 200,
            "data": b'{"data": [{"city": "bergamo", "province": "BG", "postal_code": "24121"}]}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListCitiesResponse(
            data=[City(postal_code="24121", city="BG", province="BG")]
        )
        actual = self.api.list_cities()
        actual.data[0].city = "BG"
        assert actual == expected

    def test_list_cost_centers(self):
        resp = {"status": 200, "data": b'{"data":["bg", "mi"]}', "reason": "OK"}

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListCostCentersResponse(data=["to", "mi"])
        actual = self.api.list_cost_centers(2)
        actual.data[0] = "to"
        assert actual == expected

    def test_list_countries(self):
        resp = {"status": 200, "data": b'{"data":["Spagna", "Italia"]}', "reason": "OK"}

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListCountriesResponse(data=["Spagna", "Albania"])
        actual = self.api.list_countries()
        actual.data[1] = "Albania"
        assert actual == expected

    def test_list_detailed_countries(self):
        resp = {
            "status": 200,
            "data": b'{"data": [{"name": "Italia", "settings_name": "Italia", "iso": "IT", "fiscal_iso": "IT", "uic": "086"}, {"name": "Albania", "settings_name": "Albania", "iso": "AL", "fiscal_iso": "AL", "uic": "087"}]}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListDetailedCountriesResponse(
            data=[
                DetailedCountry(
                    name="Italia",
                    settings_name="Italia",
                    iso="IT",
                    fiscal_iso="IT",
                    uic="086",
                ),
                DetailedCountry(
                    name="Albania",
                    settings_name="Albania",
                    iso="AL",
                    fiscal_iso="AL",
                    uic="087",
                ),
            ]
        )
        actual = self.api.list_detailed_countries()
        actual.data[1].name = "Albania"
        assert actual == expected

    def test_list_currencies(self):
        resp = {
            "status": 200,
            "data": b'{"data": [{"id": "EUR", "symbol": "e", "exchange_rate": "1"}]}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListCurrenciesResponse(
            data=[Currency(id="USD", symbol="e", exchange_rate="1")]
        )
        actual = self.api.list_currencies()
        actual.data[0].id = "USD"
        assert actual == expected

    def test_list_delivery_notes_default_causals(self):
        resp = {
            "status": 200,
            "data": b'{"data":["causal1", "causal2"]}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListDeliveryNotesDefaultCausalsResponse(data=["causal3", "causal2"])
        actual = self.api.list_delivery_notes_default_causals()
        actual.data[0] = "causal3"
        assert actual == expected

    def test_list_languages(self):
        resp = {
            "status": 200,
            "data": b'{"data":[{"code":"ITA","name":"Italiano"}]}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListLanguagesResponse(data=[Language(code="ITA", name="Italiano")])
        actual = self.api.list_languages()
        assert actual == expected

    def test_list_payment_accounts(self):
        resp = {
            "status": 200,
            "data": b'{"data": [{"id": 1, "name": "Conto Banca Intesa", "type": "standard", "iban": "iban_example", "sia": "sia_example", "cuc": "cuc_example", "virtual": true}]}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListPaymentAccountsResponse(
            data=[
                PaymentAccount(
                    id=2,
                    name="Conto Banca Intesa",
                    type=PaymentAccountType("standard"),
                    iban="iban_example",
                    sia="sia_example",
                    cuc="cuc_example",
                    virtual=True,
                )
            ]
        )
        actual = self.api.list_payment_accounts(2)
        actual.data[0].id = 2
        assert actual == expected

    def test_list_payment_methods(self):
        resp = {
            "status": 200,
            "data": b'{"data": [{"id": 1, "name": "name_example", "type": "standard", "is_default": true, "default_payment_account": {"id": 1, "name": "Conto Banca Intesa", "type": "standard", "iban": "iban_example", "sia": "sia_example", "cuc": "cuc_example", "virtual": true}, "details": [{"title": "title_example", "description": "description_example"}], "bank_iban": "bank_iban_example", "bank_name": "bank_name_example", "bank_beneficiary": "bank_beneficiary_example", "ei_payment_method": "ei_payment_method_example"}]}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListPaymentMethodsResponse(
            data=[
                PaymentMethod(
                    id=2,
                    name="name_example",
                    type=PaymentMethodType("standard"),
                    is_default=True,
                    default_payment_account=PaymentAccount(
                        id=1,
                        name="Conto Banca Intesa",
                        type=PaymentAccountType("standard"),
                        iban="iban_example",
                        sia="sia_example",
                        cuc="cuc_example",
                        virtual=True,
                    ),
                    details=[
                        PaymentMethodDetails(
                            title="title_example",
                            description="description_example",
                        ),
                    ],
                    bank_iban="bank_iban_example",
                    bank_name="bank_name_example",
                    bank_beneficiary="bank_beneficiary_example",
                    ei_payment_method="ei_payment_method_example",
                )
            ]
        )
        actual = self.api.list_payment_methods(2)
        actual.data[0].id = 2
        assert actual == expected

    def test_list_product_categories(self):
        resp = {"status": 200, "data": b'{"data":["cat5", "cat6"]}', "reason": "OK"}

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListProductCategoriesResponse(data=["cat7", "cat6"])
        actual = self.api.list_product_categories(2, "products")
        actual.data[0] = "cat7"
        assert actual == expected

    def test_list_received_document_categories(self):
        resp = {"status": 200, "data": b'{"data":["cat5", "cat6"]}', "reason": "OK"}

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListReceivedDocumentCategoriesResponse(data=["cat7", "cat6"])
        actual = self.api.list_received_document_categories(2)
        actual.data[0] = "cat7"
        assert actual == expected

    def test_list_revenue_centers(self):
        resp = {"status": 200, "data": b'{"data":["bg", "mi"]}', "reason": "OK"}

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListRevenueCentersResponse(data=["to", "mi"])
        actual = self.api.list_revenue_centers(2)
        actual.data[0] = "to"
        assert actual == expected

    def test_list_templates(self):
        resp = {
            "status": 200,
            "data": b'{"data":[{"id":2,"name":"Light Smoke","type":"type_example"}]}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListTemplatesResponse(
            data=[DocumentTemplate(id=2, name="Light Smoke", type="type_example")]
        )
        actual = self.api.list_templates()
        assert actual == expected

    def test_list_units_of_measure(self):
        resp = {"status": 200, "data": b'{"data":["kg", "km"]}', "reason": "OK"}

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListUnitsOfMeasureResponse(data=["kb", "km"])
        actual = self.api.list_units_of_measure()
        actual.data[0] = "kb"
        assert actual == expected

    def test_list_vat_types(self):
        resp = {
            "status": 200,
            "data": b'{"data": [{"id": 1, "value": 22.0, "description": "Non imponibile art. 123", "notes": "IVA non imponibile ai sensi dell articolo 123, comma 2", "e_invoice": true, "ei_type": "2", "ei_description": "ei_description_example", "is_disabled": true}]}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListVatTypesResponse(
            data=[
                VatType(
                    id=2,
                    value=22.0,
                    description="Non imponibile art. 123",
                    notes="IVA non imponibile ai sensi dell articolo 123, comma 2",
                    e_invoice=True,
                    ei_type="2",
                    ei_description="ei_description_example",
                    is_disabled=True,
                )
            ]
        )
        actual = self.api.list_vat_types(2)
        actual.data[0].id = 2
        assert actual == expected


if __name__ == "__main__":
    unittest.main()
