# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.27
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import unittest

import fattureincloud_python_sdk
from fattureincloud_python_sdk.models.create_webhooks_subscription_response import CreateWebhooksSubscriptionResponse
from fattureincloud_python_sdk.models.event_type import EventType
from fattureincloud_python_sdk.models.get_webhooks_subscription_response import GetWebhooksSubscriptionResponse
from fattureincloud_python_sdk.models.list_webhooks_subscriptions_response import ListWebhooksSubscriptionsResponse
from fattureincloud_python_sdk.models.modify_webhooks_subscription_response import ModifyWebhooksSubscriptionResponse
from fattureincloud_python_sdk.models.webhooks_subscription import WebhooksSubscription
from fattureincloud_python_sdk.models.webhooks_subscription_config import WebhooksSubscriptionConfig
from fattureincloud_python_sdk.models.webhooks_subscription_mapping import WebhooksSubscriptionMapping
import functions
from fattureincloud_python_sdk.api.webhooks_api import WebhooksApi  # noqa: E501
from fattureincloud_python_sdk.rest import RESTResponse


class TestWebhooksApi(unittest.TestCase):
    """WebhooksApi unit test stubs"""

    def setUp(self):
        self.api = WebhooksApi()

    def tearDown(self):
        pass

    def test_create_webhooks_subscription(self):
        resp = {
            "status": 200,
            "data": b'{"data":{"id": "SUB123", "sink": "https://endpoint.test", "verified": true, "types": ["it.fattureincloud.webhooks.cashbook.create"], "config": {"mapping": "binary"}}}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.post_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = CreateWebhooksSubscriptionResponse(
            data= WebhooksSubscription(
                id="SUB1234",
                sink="https://endpoint.test",
                verified=True,
                types=[EventType.CASHBOOK_CREATE],
                config=WebhooksSubscriptionConfig(mapping=WebhooksSubscriptionMapping('binary')),
            )
        )

        actual = self.api.create_webhooks_subscription(2)
        actual.data.id = "SUB1234"
        assert actual == expected

    def test_delete_webhooks_subscription(self):
        resp = {"status": 200, "data": b"{}", "reason": "OK"}

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.delete_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        actual = self.api.delete_webhooks_subscription(2, "SUB12345")
        assert actual == None

    def test_get_webhooks_subscription(self):
        resp = {
            "status": 200,
            "data": b'{"data":{"id": "SUB123", "sink": "https://endpoint.test", "verified": true, "types": ["it.fattureincloud.webhooks.cashbook.create"], "config": {"mapping": "binary"}}}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = GetWebhooksSubscriptionResponse(
            data= WebhooksSubscription(
                id="SUB1234",
                sink="https://endpoint.test",
                verified=True,
                types=[EventType.CASHBOOK_CREATE],
                config=WebhooksSubscriptionConfig(mapping=WebhooksSubscriptionMapping('binary')),
            )
        )

        actual = self.api.get_webhooks_subscription(2, "SUB12345")
        actual.data.id = "SUB1234"
        assert actual == expected

    def test_list_webhooks_subscriptions(self):
        resp = {
            "status": 200,
            "data": b'{"data":[{"id": "SUB123", "sink": "https://endpoint.test", "verified": true, "types": ["it.fattureincloud.webhooks.cashbook.create"], "config": {"mapping": "binary"}}, {"id": "SUB1234", "sink": "https://endpoint.test", "verified": true, "types": ["it.fattureincloud.webhooks.cashbook.create"], "config": {"mapping": "binary"}}]}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.get_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ListWebhooksSubscriptionsResponse(
            data = [
                WebhooksSubscription(
                    id="SUB0",
                    sink="https://endpoint.test",
                    verified=True,
                    types=[EventType.CASHBOOK_CREATE],
                    config=WebhooksSubscriptionConfig(mapping=WebhooksSubscriptionMapping('binary')),
                ),
                WebhooksSubscription(
                    id="SUB1",
                    sink="https://endpoint.test",
                    verified=True,
                    types=[EventType.CASHBOOK_CREATE],
                    config=WebhooksSubscriptionConfig(mapping=WebhooksSubscriptionMapping('binary')),
                )
            ]
        )

        actual = self.api.list_webhooks_subscriptions(2)
        actual.data[0].id = "SUB0"
        actual.data[1].id = "SUB1"
        assert actual == expected

    def test_modify_webhooks_subscription(self):
        resp = {
            "status": 200,
            "data": b'{"data":{"id": "SUB123", "sink": "https://endpoint.test", "verified": true, "types": ["it.fattureincloud.webhooks.cashbook.create"], "config": {"mapping": "binary"}}}',
            "reason": "OK",
        }

        mock_resp = RESTResponse(functions.Dict2Class(resp))
        mock_resp.getheader = unittest.mock.MagicMock(return_value=None)
        mock_resp.getheaders = unittest.mock.MagicMock(return_value=None)

        self.api.api_client.rest_client.put_request = unittest.mock.MagicMock(
            return_value=mock_resp
        )
        expected = ModifyWebhooksSubscriptionResponse(
            data= WebhooksSubscription(
                id="SUB1234",
                sink="https://endpoint.test",
                verified=True,
                types=[EventType.CASHBOOK_CREATE],
                config=WebhooksSubscriptionConfig(mapping=WebhooksSubscriptionMapping('binary')),
            )
        )

        actual = self.api.modify_webhooks_subscription(2, "SUB12345")
        actual.data.id = "SUB1234"
        assert actual == expected


if __name__ == "__main__":
    unittest.main()
