# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

    The version of the OpenAPI document: 2.0.30
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr
from pydantic import Field
from fattureincloud_python_sdk.models.company_type import CompanyType

try:
    from typing import Self
except ImportError:
    from typing_extensions import Self


class ControlledCompany(BaseModel):
    """
    ControlledCompany
    """  # noqa: E501

    id: Optional[StrictInt] = Field(default=None, description="Controlled company id")
    name: Optional[StrictStr] = Field(default=None, description="Controlled company id")
    type: Optional[CompanyType] = None
    access_token: Optional[StrictStr] = Field(
        default=None,
        description="Controlled company access token Only if type=company]",
    )
    connection_id: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Controlled company connection id"
    )
    tax_code: Optional[StrictStr] = Field(
        default=None, description="Controlled company tax code"
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "name",
        "type",
        "access_token",
        "connection_id",
        "tax_code",
    ]

    model_config = {"populate_by_name": True, "validate_assignment": True}

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ControlledCompany from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={},
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of ControlledCompany from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "name": obj.get("name"),
                "type": obj.get("type"),
                "access_token": obj.get("access_token"),
                "connection_id": obj.get("connection_id"),
                "tax_code": obj.get("tax_code"),
            }
        )
        return _obj
