"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 400.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.9
    Contact: info@fattureincloud.it
    Generated by: https://openapi-generator.tech
"""

import unittest
import json
import datetime
from fattureincloud_python_sdk.models.archive_document import ArchiveDocument
from functions import json_serial
from functions import create_from_json


class TestArchiveDocument(unittest.TestCase):
    """ArchiveDocument unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testArchiveDocument(self):
        """Test ArchiveDocument"""
        model = ArchiveDocument(
            id=12345,
            date=datetime.datetime.strptime("2021-08-20", "%Y-%m-%d").date(),
            description="spesa 2",
            category="Altri documenti",
            attachment_token="spesa2.pdf",
        )
        expected_json = '{"id": 12345, "date": "2021-08-20", "description": "spesa 2", "category": "Altri documenti", "attachment_token": "spesa2.pdf"}'
        actual_json = json.dumps(model.to_dict(), default=json_serial)
        assert actual_json == expected_json

        readonly_json = '{"date": "2021-08-20", "description": "spesa 2", "category": "Altri documenti", "id": 12345, "attachment_token": "fff", "attachment_url": "spesa2.pdf"}'
        model = ArchiveDocument(
            id=12345,
            date=datetime.datetime.strptime("2021-08-20", "%Y-%m-%d").date(),
            description="spesa 2",
            category="Altri documenti",
            attachment_token="fff",
            attachment_url="spesa2.pdf",
        )
        assert model == create_from_json(readonly_json, "ArchiveDocument")


if __name__ == "__main__":
    unittest.main()
