# FattureInCloud Python SDK

[![PyPI](https://img.shields.io/pypi/v/fattureincloud-python-sdk?color=g)](https://pypi.org/project/fattureincloud-python-sdk/) ![unit tests](https://github.com/fattureincloud/fattureincloud-python-sdk/actions/workflows/validate.yaml/badge.svg)

# fattureincloud-python-sdk

Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.

The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0.32
- Package version: 2.0.19
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
  For more information, please visit [https://www.fattureincloud.it](https://www.fattureincloud.it)

## Requirements.

Python >= 3.7

## Installation & Usage

### pip install

You can install our python package directly using:

```sh
pip install fattureincloud-python-sdk
```

(you may need to run `pip` with root permission: `sudo pip install fattureincloud-python-sdk`)

Then import the package:

```python
import fattureincloud_python_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import fattureincloud_python_sdk
from fattureincloud_python_sdk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api-v2.fattureincloud.it
# See configuration.py for a list of all supported configuration parameters.
configuration = fattureincloud_python_sdk.Configuration(
    host = "https://api-v2.fattureincloud.it"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]


# Enter a context with an instance of the API client
with fattureincloud_python_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = fattureincloud_python_sdk.ArchiveApi(api_client)
    company_id = 12345 # int | The ID of the company.
    create_archive_document_request = {"data":{"date":"2021-08-20","category":"Altri documenti","description":"spesa 1","attachment_token":"ibfjdbf94ey9w94g3w894qbasrga"}} # CreateArchiveDocumentRequest | The Archive Document. (optional)

    try:
        # Create Archive Document
        api_response = api_instance.create_archive_document(company_id, create_archive_document_request=create_archive_document_request)
        print("The response of ArchiveApi->create_archive_document:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ArchiveApi->create_archive_document: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api-v2.fattureincloud.it*

| Class                  | Method                                                                                                          | HTTP request                                                                  | Description                           |
| ---------------------- | --------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------- | ------------------------------------- |
| _ArchiveApi_           | [**create_archive_document**](docs/ArchiveApi.md#create_archive_document)                                       | **POST** /c/{company_id}/archive                                              | Create Archive Document               |
| _ArchiveApi_           | [**delete_archive_document**](docs/ArchiveApi.md#delete_archive_document)                                       | **DELETE** /c/{company_id}/archive/{document_id}                              | Delete Archive Document               |
| _ArchiveApi_           | [**get_archive_document**](docs/ArchiveApi.md#get_archive_document)                                             | **GET** /c/{company_id}/archive/{document_id}                                 | Get Archive Document                  |
| _ArchiveApi_           | [**list_archive_documents**](docs/ArchiveApi.md#list_archive_documents)                                         | **GET** /c/{company_id}/archive                                               | List Archive Documents                |
| _ArchiveApi_           | [**modify_archive_document**](docs/ArchiveApi.md#modify_archive_document)                                       | **PUT** /c/{company_id}/archive/{document_id}                                 | Modify Archive Document               |
| _ArchiveApi_           | [**upload_archive_document_attachment**](docs/ArchiveApi.md#upload_archive_document_attachment)                 | **POST** /c/{company_id}/archive/attachment                                   | Upload Archive Document Attachment    |
| _CashbookApi_          | [**create_cashbook_entry**](docs/CashbookApi.md#create_cashbook_entry)                                          | **POST** /c/{company_id}/cashbook                                             | Create Cashbook Entry                 |
| _CashbookApi_          | [**delete_cashbook_entry**](docs/CashbookApi.md#delete_cashbook_entry)                                          | **DELETE** /c/{company_id}/cashbook/{document_id}                             | Delete Cashbook Entry                 |
| _CashbookApi_          | [**get_cashbook_entry**](docs/CashbookApi.md#get_cashbook_entry)                                                | **GET** /c/{company_id}/cashbook/{document_id}                                | Get Cashbook Entry                    |
| _CashbookApi_          | [**list_cashbook_entries**](docs/CashbookApi.md#list_cashbook_entries)                                          | **GET** /c/{company_id}/cashbook                                              | List Cashbook Entries                 |
| _CashbookApi_          | [**modify_cashbook_entry**](docs/CashbookApi.md#modify_cashbook_entry)                                          | **PUT** /c/{company_id}/cashbook/{document_id}                                | Modify Cashbook Entry                 |
| _ClientsApi_           | [**create_client**](docs/ClientsApi.md#create_client)                                                           | **POST** /c/{company_id}/entities/clients                                     | Create Client                         |
| _ClientsApi_           | [**delete_client**](docs/ClientsApi.md#delete_client)                                                           | **DELETE** /c/{company_id}/entities/clients/{client_id}                       | Delete Client                         |
| _ClientsApi_           | [**get_client**](docs/ClientsApi.md#get_client)                                                                 | **GET** /c/{company_id}/entities/clients/{client_id}                          | Get Client                            |
| _ClientsApi_           | [**list_clients**](docs/ClientsApi.md#list_clients)                                                             | **GET** /c/{company_id}/entities/clients                                      | List Clients                          |
| _ClientsApi_           | [**modify_client**](docs/ClientsApi.md#modify_client)                                                           | **PUT** /c/{company_id}/entities/clients/{client_id}                          | Modify Client                         |
| _CompaniesApi_         | [**get_company_info**](docs/CompaniesApi.md#get_company_info)                                                   | **GET** /c/{company_id}/company/info                                          | Get Company Info                      |
| _CompaniesApi_         | [**get_company_plan_usage**](docs/CompaniesApi.md#get_company_plan_usage)                                       | **GET** /c/{company_id}/company/plan_usage                                    | Get Company Plan Usage                |
| _EmailsApi_            | [**list_emails**](docs/EmailsApi.md#list_emails)                                                                | **GET** /c/{company_id}/emails                                                | List Emails                           |
| _InfoApi_              | [**list_archive_categories**](docs/InfoApi.md#list_archive_categories)                                          | **GET** /c/{company_id}/info/archive_categories                               | List Archive Categories               |
| _InfoApi_              | [**list_cities**](docs/InfoApi.md#list_cities)                                                                  | **GET** /info/cities                                                          | List Cities                           |
| _InfoApi_              | [**list_cost_centers**](docs/InfoApi.md#list_cost_centers)                                                      | **GET** /c/{company_id}/info/cost_centers                                     | List Cost Centers                     |
| _InfoApi_              | [**list_countries**](docs/InfoApi.md#list_countries)                                                            | **GET** /info/countries                                                       | List Countries                        |
| _InfoApi_              | [**list_currencies**](docs/InfoApi.md#list_currencies)                                                          | **GET** /info/currencies                                                      | List Currencies                       |
| _InfoApi_              | [**list_delivery_notes_default_causals**](docs/InfoApi.md#list_delivery_notes_default_causals)                  | **GET** /info/dn_causals                                                      | List Delivery Notes Default Causals   |
| _InfoApi_              | [**list_detailed_countries**](docs/InfoApi.md#list_detailed_countries)                                          | **GET** /info/detailed_countries                                              | List Detailed Countries               |
| _InfoApi_              | [**list_languages**](docs/InfoApi.md#list_languages)                                                            | **GET** /info/languages                                                       | List Languages                        |
| _InfoApi_              | [**list_payment_accounts**](docs/InfoApi.md#list_payment_accounts)                                              | **GET** /c/{company_id}/info/payment_accounts                                 | List Payment Accounts                 |
| _InfoApi_              | [**list_payment_methods**](docs/InfoApi.md#list_payment_methods)                                                | **GET** /c/{company_id}/info/payment_methods                                  | List Payment Methods                  |
| _InfoApi_              | [**list_product_categories**](docs/InfoApi.md#list_product_categories)                                          | **GET** /c/{company_id}/info/product_categories                               | List Product Categories               |
| _InfoApi_              | [**list_received_document_categories**](docs/InfoApi.md#list_received_document_categories)                      | **GET** /c/{company_id}/info/received_document_categories                     | List Received Document Categories     |
| _InfoApi_              | [**list_revenue_centers**](docs/InfoApi.md#list_revenue_centers)                                                | **GET** /c/{company_id}/info/revenue_centers                                  | List Revenue Centers                  |
| _InfoApi_              | [**list_templates**](docs/InfoApi.md#list_templates)                                                            | **GET** /info/templates                                                       | List Templates                        |
| _InfoApi_              | [**list_units_of_measure**](docs/InfoApi.md#list_units_of_measure)                                              | **GET** /info/measures                                                        | List Units of Measure                 |
| _InfoApi_              | [**list_vat_types**](docs/InfoApi.md#list_vat_types)                                                            | **GET** /c/{company_id}/info/vat_types                                        | List Vat Types                        |
| _IssuedDocumentsApi_   | [**create_issued_document**](docs/IssuedDocumentsApi.md#create_issued_document)                                 | **POST** /c/{company_id}/issued_documents                                     | Create Issued Document                |
| _IssuedDocumentsApi_   | [**delete_issued_document**](docs/IssuedDocumentsApi.md#delete_issued_document)                                 | **DELETE** /c/{company_id}/issued_documents/{document_id}                     | Delete Issued Document                |
| _IssuedDocumentsApi_   | [**delete_issued_document_attachment**](docs/IssuedDocumentsApi.md#delete_issued_document_attachment)           | **DELETE** /c/{company_id}/issued_documents/{document_id}/attachment          | Delete Issued Document Attachment     |
| _IssuedDocumentsApi_   | [**get_email_data**](docs/IssuedDocumentsApi.md#get_email_data)                                                 | **GET** /c/{company_id}/issued_documents/{document_id}/email                  | Get Email Data                        |
| _IssuedDocumentsApi_   | [**get_existing_issued_document_totals**](docs/IssuedDocumentsApi.md#get_existing_issued_document_totals)       | **POST** /c/{company_id}/issued_documents/{document_id}/totals                | Get Existing Issued Document Totals   |
| _IssuedDocumentsApi_   | [**get_issued_document**](docs/IssuedDocumentsApi.md#get_issued_document)                                       | **GET** /c/{company_id}/issued_documents/{document_id}                        | Get Issued Document                   |
| _IssuedDocumentsApi_   | [**get_issued_document_pre_create_info**](docs/IssuedDocumentsApi.md#get_issued_document_pre_create_info)       | **GET** /c/{company_id}/issued_documents/info                                 | Get Issued Document Pre-Create Info   |
| _IssuedDocumentsApi_   | [**get_new_issued_document_totals**](docs/IssuedDocumentsApi.md#get_new_issued_document_totals)                 | **POST** /c/{company_id}/issued_documents/totals                              | Get New Issued Document Totals        |
| _IssuedDocumentsApi_   | [**join_issued_documents**](docs/IssuedDocumentsApi.md#join_issued_documents)                                   | **GET** /c/{company_id}/issued_documents/join                                 | Join Issued Documents                 |
| _IssuedDocumentsApi_   | [**list_issued_documents**](docs/IssuedDocumentsApi.md#list_issued_documents)                                   | **GET** /c/{company_id}/issued_documents                                      | List Issued Documents                 |
| _IssuedDocumentsApi_   | [**modify_issued_document**](docs/IssuedDocumentsApi.md#modify_issued_document)                                 | **PUT** /c/{company_id}/issued_documents/{document_id}                        | Modify Issued Document                |
| _IssuedDocumentsApi_   | [**schedule_email**](docs/IssuedDocumentsApi.md#schedule_email)                                                 | **POST** /c/{company_id}/issued_documents/{document_id}/email                 | Schedule Email                        |
| _IssuedDocumentsApi_   | [**transform_issued_document**](docs/IssuedDocumentsApi.md#transform_issued_document)                           | **GET** /c/{company_id}/issued_documents/transform                            | Transform Issued Document             |
| _IssuedDocumentsApi_   | [**upload_issued_document_attachment**](docs/IssuedDocumentsApi.md#upload_issued_document_attachment)           | **POST** /c/{company_id}/issued_documents/attachment                          | Upload Issued Document Attachment     |
| _IssuedEInvoicesApi_   | [**get_e_invoice_rejection_reason**](docs/IssuedEInvoicesApi.md#get_e_invoice_rejection_reason)                 | **GET** /c/{company_id}/issued_documents/{document_id}/e_invoice/error_reason | Get E-Invoice Rejection Reason        |
| _IssuedEInvoicesApi_   | [**get_e_invoice_xml**](docs/IssuedEInvoicesApi.md#get_e_invoice_xml)                                           | **GET** /c/{company_id}/issued_documents/{document_id}/e_invoice/xml          | Get E-Invoice XML                     |
| _IssuedEInvoicesApi_   | [**send_e_invoice**](docs/IssuedEInvoicesApi.md#send_e_invoice)                                                 | **POST** /c/{company_id}/issued_documents/{document_id}/e_invoice/send        | Send E-Invoice                        |
| _IssuedEInvoicesApi_   | [**verify_e_invoice_xml**](docs/IssuedEInvoicesApi.md#verify_e_invoice_xml)                                     | **GET** /c/{company_id}/issued_documents/{document_id}/e_invoice/xml_verify   | Verify E-Invoice XML                  |
| _ProductsApi_          | [**create_product**](docs/ProductsApi.md#create_product)                                                        | **POST** /c/{company_id}/products                                             | Create Product                        |
| _ProductsApi_          | [**delete_product**](docs/ProductsApi.md#delete_product)                                                        | **DELETE** /c/{company_id}/products/{product_id}                              | Delete Product                        |
| _ProductsApi_          | [**get_product**](docs/ProductsApi.md#get_product)                                                              | **GET** /c/{company_id}/products/{product_id}                                 | Get Product                           |
| _ProductsApi_          | [**list_products**](docs/ProductsApi.md#list_products)                                                          | **GET** /c/{company_id}/products                                              | List Products                         |
| _ProductsApi_          | [**modify_product**](docs/ProductsApi.md#modify_product)                                                        | **PUT** /c/{company_id}/products/{product_id}                                 | Modify Product                        |
| _ReceiptsApi_          | [**create_receipt**](docs/ReceiptsApi.md#create_receipt)                                                        | **POST** /c/{company_id}/receipts                                             | Create Receipt                        |
| _ReceiptsApi_          | [**delete_receipt**](docs/ReceiptsApi.md#delete_receipt)                                                        | **DELETE** /c/{company_id}/receipts/{document_id}                             | Delete Receipt                        |
| _ReceiptsApi_          | [**get_receipt**](docs/ReceiptsApi.md#get_receipt)                                                              | **GET** /c/{company_id}/receipts/{document_id}                                | Get Receipt                           |
| _ReceiptsApi_          | [**get_receipt_pre_create_info**](docs/ReceiptsApi.md#get_receipt_pre_create_info)                              | **GET** /c/{company_id}/receipts/info                                         | Get Receipt Pre-Create Info           |
| _ReceiptsApi_          | [**get_receipts_monthly_totals**](docs/ReceiptsApi.md#get_receipts_monthly_totals)                              | **GET** /c/{company_id}/receipts/monthly_totals                               | Get Receipts Monthly Totals           |
| _ReceiptsApi_          | [**list_receipts**](docs/ReceiptsApi.md#list_receipts)                                                          | **GET** /c/{company_id}/receipts                                              | List Receipts                         |
| _ReceiptsApi_          | [**modify_receipt**](docs/ReceiptsApi.md#modify_receipt)                                                        | **PUT** /c/{company_id}/receipts/{document_id}                                | Modify Receipt                        |
| _ReceivedDocumentsApi_ | [**create_received_document**](docs/ReceivedDocumentsApi.md#create_received_document)                           | **POST** /c/{company_id}/received_documents                                   | Create Received Document              |
| _ReceivedDocumentsApi_ | [**delete_received_document**](docs/ReceivedDocumentsApi.md#delete_received_document)                           | **DELETE** /c/{company_id}/received_documents/{document_id}                   | Delete Received Document              |
| _ReceivedDocumentsApi_ | [**delete_received_document_attachment**](docs/ReceivedDocumentsApi.md#delete_received_document_attachment)     | **DELETE** /c/{company_id}/received_documents/{document_id}/attachment        | Delete Received Document Attachment   |
| _ReceivedDocumentsApi_ | [**get_existing_received_document_totals**](docs/ReceivedDocumentsApi.md#get_existing_received_document_totals) | **POST** /c/{company_id}/received_documents/{document_id}/totals              | Get Existing Received Document Totals |
| _ReceivedDocumentsApi_ | [**get_new_received_document_totals**](docs/ReceivedDocumentsApi.md#get_new_received_document_totals)           | **POST** /c/{company_id}/received_documents/totals                            | Get New Received Document Totals      |
| _ReceivedDocumentsApi_ | [**get_received_document**](docs/ReceivedDocumentsApi.md#get_received_document)                                 | **GET** /c/{company_id}/received_documents/{document_id}                      | Get Received Document                 |
| _ReceivedDocumentsApi_ | [**get_received_document_pre_create_info**](docs/ReceivedDocumentsApi.md#get_received_document_pre_create_info) | **GET** /c/{company_id}/received_documents/info                               | Get Received Document Pre-Create Info |
| _ReceivedDocumentsApi_ | [**list_received_documents**](docs/ReceivedDocumentsApi.md#list_received_documents)                             | **GET** /c/{company_id}/received_documents                                    | List Received Documents               |
| _ReceivedDocumentsApi_ | [**modify_received_document**](docs/ReceivedDocumentsApi.md#modify_received_document)                           | **PUT** /c/{company_id}/received_documents/{document_id}                      | Modify Received Document              |
| _ReceivedDocumentsApi_ | [**upload_received_document_attachment**](docs/ReceivedDocumentsApi.md#upload_received_document_attachment)     | **POST** /c/{company_id}/received_documents/attachment                        | Upload Received Document Attachment   |
| _SettingsApi_          | [**create_payment_account**](docs/SettingsApi.md#create_payment_account)                                        | **POST** /c/{company_id}/settings/payment_accounts                            | Create Payment Account                |
| _SettingsApi_          | [**create_payment_method**](docs/SettingsApi.md#create_payment_method)                                          | **POST** /c/{company_id}/settings/payment_methods                             | Create Payment Method                 |
| _SettingsApi_          | [**create_vat_type**](docs/SettingsApi.md#create_vat_type)                                                      | **POST** /c/{company_id}/settings/vat_types                                   | Create Vat Type                       |
| _SettingsApi_          | [**delete_payment_account**](docs/SettingsApi.md#delete_payment_account)                                        | **DELETE** /c/{company_id}/settings/payment_accounts/{payment_account_id}     | Delete Payment Account                |
| _SettingsApi_          | [**delete_payment_method**](docs/SettingsApi.md#delete_payment_method)                                          | **DELETE** /c/{company_id}/settings/payment_methods/{payment_method_id}       | Delete Payment Method                 |
| _SettingsApi_          | [**delete_vat_type**](docs/SettingsApi.md#delete_vat_type)                                                      | **DELETE** /c/{company_id}/settings/vat_types/{vat_type_id}                   | Delete Vat Type                       |
| _SettingsApi_          | [**get_payment_account**](docs/SettingsApi.md#get_payment_account)                                              | **GET** /c/{company_id}/settings/payment_accounts/{payment_account_id}        | Get Payment Account                   |
| _SettingsApi_          | [**get_payment_method**](docs/SettingsApi.md#get_payment_method)                                                | **GET** /c/{company_id}/settings/payment_methods/{payment_method_id}          | Get Payment Method                    |
| _SettingsApi_          | [**get_vat_type**](docs/SettingsApi.md#get_vat_type)                                                            | **GET** /c/{company_id}/settings/vat_types/{vat_type_id}                      | Get Vat Type                          |
| _SettingsApi_          | [**modify_payment_account**](docs/SettingsApi.md#modify_payment_account)                                        | **PUT** /c/{company_id}/settings/payment_accounts/{payment_account_id}        | Modify Payment Account                |
| _SettingsApi_          | [**modify_payment_method**](docs/SettingsApi.md#modify_payment_method)                                          | **PUT** /c/{company_id}/settings/payment_methods/{payment_method_id}          | Modify Payment Method                 |
| _SettingsApi_          | [**modify_vat_type**](docs/SettingsApi.md#modify_vat_type)                                                      | **PUT** /c/{company_id}/settings/vat_types/{vat_type_id}                      | Modify Vat Type                       |
| _SuppliersApi_         | [**create_supplier**](docs/SuppliersApi.md#create_supplier)                                                     | **POST** /c/{company_id}/entities/suppliers                                   | Create Supplier                       |
| _SuppliersApi_         | [**delete_supplier**](docs/SuppliersApi.md#delete_supplier)                                                     | **DELETE** /c/{company_id}/entities/suppliers/{supplier_id}                   | Delete Supplier                       |
| _SuppliersApi_         | [**get_supplier**](docs/SuppliersApi.md#get_supplier)                                                           | **GET** /c/{company_id}/entities/suppliers/{supplier_id}                      | Get Supplier                          |
| _SuppliersApi_         | [**list_suppliers**](docs/SuppliersApi.md#list_suppliers)                                                       | **GET** /c/{company_id}/entities/suppliers                                    | List Suppliers                        |
| _SuppliersApi_         | [**modify_supplier**](docs/SuppliersApi.md#modify_supplier)                                                     | **PUT** /c/{company_id}/entities/suppliers/{supplier_id}                      | Modify Supplier                       |
| _TaxesApi_             | [**create_f24**](docs/TaxesApi.md#create_f24)                                                                   | **POST** /c/{company_id}/taxes                                                | Create F24                            |
| _TaxesApi_             | [**delete_f24**](docs/TaxesApi.md#delete_f24)                                                                   | **DELETE** /c/{company_id}/taxes/{document_id}                                | Delete F24                            |
| _TaxesApi_             | [**delete_f24_attachment**](docs/TaxesApi.md#delete_f24_attachment)                                             | **DELETE** /c/{company_id}/taxes/{document_id}/attachment                     | Delete F24 Attachment                 |
| _TaxesApi_             | [**get_f24**](docs/TaxesApi.md#get_f24)                                                                         | **GET** /c/{company_id}/taxes/{document_id}                                   | Get F24                               |
| _TaxesApi_             | [**list_f24**](docs/TaxesApi.md#list_f24)                                                                       | **GET** /c/{company_id}/taxes                                                 | List F24                              |
| _TaxesApi_             | [**modify_f24**](docs/TaxesApi.md#modify_f24)                                                                   | **PUT** /c/{company_id}/taxes/{document_id}                                   | Modify F24                            |
| _TaxesApi_             | [**upload_f24_attachment**](docs/TaxesApi.md#upload_f24_attachment)                                             | **POST** /c/{company_id}/taxes/attachment                                     | Upload F24 Attachment                 |
| _UserApi_              | [**get_user_info**](docs/UserApi.md#get_user_info)                                                              | **GET** /user/info                                                            | Get User Info                         |
| _UserApi_              | [**list_user_companies**](docs/UserApi.md#list_user_companies)                                                  | **GET** /user/companies                                                       | List User Companies                   |
| _WebhooksApi_          | [**create_webhooks_subscription**](docs/WebhooksApi.md#create_webhooks_subscription)                            | **POST** /c/{company_id}/subscriptions                                        | Create a Webhook Subscription         |
| _WebhooksApi_          | [**delete_webhooks_subscription**](docs/WebhooksApi.md#delete_webhooks_subscription)                            | **DELETE** /c/{company_id}/subscriptions/{subscription_id}                    | Delete Webhooks Subscription          |
| _WebhooksApi_          | [**get_webhooks_subscription**](docs/WebhooksApi.md#get_webhooks_subscription)                                  | **GET** /c/{company_id}/subscriptions/{subscription_id}                       | Get Webhooks Subscription             |
| _WebhooksApi_          | [**list_webhooks_subscriptions**](docs/WebhooksApi.md#list_webhooks_subscriptions)                              | **GET** /c/{company_id}/subscriptions                                         | List Webhooks Subscriptions           |
| _WebhooksApi_          | [**modify_webhooks_subscription**](docs/WebhooksApi.md#modify_webhooks_subscription)                            | **PUT** /c/{company_id}/subscriptions/{subscription_id}                       | Modify Webhooks Subscription          |

## Documentation For Models

- [ArchiveDocument](docs/ArchiveDocument.md)
- [AttachmentData](docs/AttachmentData.md)
- [CashbookEntry](docs/CashbookEntry.md)
- [CashbookEntryDocument](docs/CashbookEntryDocument.md)
- [CashbookEntryKind](docs/CashbookEntryKind.md)
- [CashbookEntryType](docs/CashbookEntryType.md)
- [City](docs/City.md)
- [Client](docs/Client.md)
- [ClientType](docs/ClientType.md)
- [Company](docs/Company.md)
- [CompanyInfo](docs/CompanyInfo.md)
- [CompanyInfoAccessInfo](docs/CompanyInfoAccessInfo.md)
- [CompanyInfoPlanInfo](docs/CompanyInfoPlanInfo.md)
- [CompanyInfoPlanInfoFunctions](docs/CompanyInfoPlanInfoFunctions.md)
- [CompanyInfoPlanInfoFunctionsStatus](docs/CompanyInfoPlanInfoFunctionsStatus.md)
- [CompanyInfoPlanInfoLimits](docs/CompanyInfoPlanInfoLimits.md)
- [CompanyPlanUsage](docs/CompanyPlanUsage.md)
- [CompanyType](docs/CompanyType.md)
- [ControlledCompany](docs/ControlledCompany.md)
- [CreateArchiveDocumentRequest](docs/CreateArchiveDocumentRequest.md)
- [CreateArchiveDocumentResponse](docs/CreateArchiveDocumentResponse.md)
- [CreateCashbookEntryRequest](docs/CreateCashbookEntryRequest.md)
- [CreateCashbookEntryResponse](docs/CreateCashbookEntryResponse.md)
- [CreateClientRequest](docs/CreateClientRequest.md)
- [CreateClientResponse](docs/CreateClientResponse.md)
- [CreateF24Request](docs/CreateF24Request.md)
- [CreateF24Response](docs/CreateF24Response.md)
- [CreateIssuedDocumentRequest](docs/CreateIssuedDocumentRequest.md)
- [CreateIssuedDocumentResponse](docs/CreateIssuedDocumentResponse.md)
- [CreatePaymentAccountRequest](docs/CreatePaymentAccountRequest.md)
- [CreatePaymentAccountResponse](docs/CreatePaymentAccountResponse.md)
- [CreatePaymentMethodRequest](docs/CreatePaymentMethodRequest.md)
- [CreatePaymentMethodResponse](docs/CreatePaymentMethodResponse.md)
- [CreateProductRequest](docs/CreateProductRequest.md)
- [CreateProductResponse](docs/CreateProductResponse.md)
- [CreateReceiptRequest](docs/CreateReceiptRequest.md)
- [CreateReceiptResponse](docs/CreateReceiptResponse.md)
- [CreateReceivedDocumentRequest](docs/CreateReceivedDocumentRequest.md)
- [CreateReceivedDocumentResponse](docs/CreateReceivedDocumentResponse.md)
- [CreateSupplierRequest](docs/CreateSupplierRequest.md)
- [CreateSupplierResponse](docs/CreateSupplierResponse.md)
- [CreateVatTypeRequest](docs/CreateVatTypeRequest.md)
- [CreateVatTypeResponse](docs/CreateVatTypeResponse.md)
- [CreateWebhooksSubscriptionRequest](docs/CreateWebhooksSubscriptionRequest.md)
- [CreateWebhooksSubscriptionResponse](docs/CreateWebhooksSubscriptionResponse.md)
- [Currency](docs/Currency.md)
- [DetailedCountry](docs/DetailedCountry.md)
- [DocumentTemplate](docs/DocumentTemplate.md)
- [EInvoiceRejectionReason](docs/EInvoiceRejectionReason.md)
- [Email](docs/Email.md)
- [EmailAttachment](docs/EmailAttachment.md)
- [EmailData](docs/EmailData.md)
- [EmailDataDefaultSenderEmail](docs/EmailDataDefaultSenderEmail.md)
- [EmailRecipientStatus](docs/EmailRecipientStatus.md)
- [EmailSchedule](docs/EmailSchedule.md)
- [EmailScheduleInclude](docs/EmailScheduleInclude.md)
- [EmailStatus](docs/EmailStatus.md)
- [Entity](docs/Entity.md)
- [EntityType](docs/EntityType.md)
- [EventType](docs/EventType.md)
- [F24](docs/F24.md)
- [F24Status](docs/F24Status.md)
- [FattureInCloudPlanType](docs/FattureInCloudPlanType.md)
- [FunctionStatus](docs/FunctionStatus.md)
- [GetArchiveDocumentResponse](docs/GetArchiveDocumentResponse.md)
- [GetCashbookEntryResponse](docs/GetCashbookEntryResponse.md)
- [GetClientResponse](docs/GetClientResponse.md)
- [GetCompanyInfoResponse](docs/GetCompanyInfoResponse.md)
- [GetCompanyPlanUsageResponse](docs/GetCompanyPlanUsageResponse.md)
- [GetEInvoiceRejectionReasonResponse](docs/GetEInvoiceRejectionReasonResponse.md)
- [GetEmailDataResponse](docs/GetEmailDataResponse.md)
- [GetExistingIssuedDocumentTotalsRequest](docs/GetExistingIssuedDocumentTotalsRequest.md)
- [GetExistingIssuedDocumentTotalsResponse](docs/GetExistingIssuedDocumentTotalsResponse.md)
- [GetExistingReceivedDocumentTotalsRequest](docs/GetExistingReceivedDocumentTotalsRequest.md)
- [GetExistingReceivedDocumentTotalsResponse](docs/GetExistingReceivedDocumentTotalsResponse.md)
- [GetF24Response](docs/GetF24Response.md)
- [GetIssuedDocumentPreCreateInfoResponse](docs/GetIssuedDocumentPreCreateInfoResponse.md)
- [GetIssuedDocumentResponse](docs/GetIssuedDocumentResponse.md)
- [GetNewIssuedDocumentTotalsRequest](docs/GetNewIssuedDocumentTotalsRequest.md)
- [GetNewIssuedDocumentTotalsResponse](docs/GetNewIssuedDocumentTotalsResponse.md)
- [GetNewReceivedDocumentTotalsRequest](docs/GetNewReceivedDocumentTotalsRequest.md)
- [GetNewReceivedDocumentTotalsResponse](docs/GetNewReceivedDocumentTotalsResponse.md)
- [GetPaymentAccountResponse](docs/GetPaymentAccountResponse.md)
- [GetPaymentMethodResponse](docs/GetPaymentMethodResponse.md)
- [GetProductResponse](docs/GetProductResponse.md)
- [GetReceiptPreCreateInfoResponse](docs/GetReceiptPreCreateInfoResponse.md)
- [GetReceiptResponse](docs/GetReceiptResponse.md)
- [GetReceiptsMonthlyTotalsResponse](docs/GetReceiptsMonthlyTotalsResponse.md)
- [GetReceivedDocumentPreCreateInfoResponse](docs/GetReceivedDocumentPreCreateInfoResponse.md)
- [GetReceivedDocumentResponse](docs/GetReceivedDocumentResponse.md)
- [GetSupplierResponse](docs/GetSupplierResponse.md)
- [GetUserInfoResponse](docs/GetUserInfoResponse.md)
- [GetUserInfoResponseEmailConfirmationState](docs/GetUserInfoResponseEmailConfirmationState.md)
- [GetUserInfoResponseInfo](docs/GetUserInfoResponseInfo.md)
- [GetVatTypeResponse](docs/GetVatTypeResponse.md)
- [GetWebhooksSubscriptionResponse](docs/GetWebhooksSubscriptionResponse.md)
- [IssuedDocument](docs/IssuedDocument.md)
- [IssuedDocumentEiData](docs/IssuedDocumentEiData.md)
- [IssuedDocumentExtraData](docs/IssuedDocumentExtraData.md)
- [IssuedDocumentItemsListItem](docs/IssuedDocumentItemsListItem.md)
- [IssuedDocumentOptions](docs/IssuedDocumentOptions.md)
- [IssuedDocumentPaymentsListItem](docs/IssuedDocumentPaymentsListItem.md)
- [IssuedDocumentPaymentsListItemPaymentTerms](docs/IssuedDocumentPaymentsListItemPaymentTerms.md)
- [IssuedDocumentPreCreateInfo](docs/IssuedDocumentPreCreateInfo.md)
- [IssuedDocumentPreCreateInfoDefaultValues](docs/IssuedDocumentPreCreateInfoDefaultValues.md)
- [IssuedDocumentPreCreateInfoExtraDataDefaultValues](docs/IssuedDocumentPreCreateInfoExtraDataDefaultValues.md)
- [IssuedDocumentPreCreateInfoItemsDefaultValues](docs/IssuedDocumentPreCreateInfoItemsDefaultValues.md)
- [IssuedDocumentStatus](docs/IssuedDocumentStatus.md)
- [IssuedDocumentTotals](docs/IssuedDocumentTotals.md)
- [IssuedDocumentType](docs/IssuedDocumentType.md)
- [JoinIssuedDocumentsResponse](docs/JoinIssuedDocumentsResponse.md)
- [Language](docs/Language.md)
- [ListArchiveCategoriesResponse](docs/ListArchiveCategoriesResponse.md)
- [ListArchiveDocumentsResponse](docs/ListArchiveDocumentsResponse.md)
- [ListArchiveDocumentsResponsePage](docs/ListArchiveDocumentsResponsePage.md)
- [ListCashbookEntriesResponse](docs/ListCashbookEntriesResponse.md)
- [ListCitiesResponse](docs/ListCitiesResponse.md)
- [ListClientsResponse](docs/ListClientsResponse.md)
- [ListClientsResponsePage](docs/ListClientsResponsePage.md)
- [ListCostCentersResponse](docs/ListCostCentersResponse.md)
- [ListCountriesResponse](docs/ListCountriesResponse.md)
- [ListCurrenciesResponse](docs/ListCurrenciesResponse.md)
- [ListDeliveryNotesDefaultCausalsResponse](docs/ListDeliveryNotesDefaultCausalsResponse.md)
- [ListDetailedCountriesResponse](docs/ListDetailedCountriesResponse.md)
- [ListEmailsResponse](docs/ListEmailsResponse.md)
- [ListEmailsResponsePage](docs/ListEmailsResponsePage.md)
- [ListF24Response](docs/ListF24Response.md)
- [ListF24ResponseAggregatedData](docs/ListF24ResponseAggregatedData.md)
- [ListF24ResponseAggregation](docs/ListF24ResponseAggregation.md)
- [ListF24ResponsePage](docs/ListF24ResponsePage.md)
- [ListIssuedDocumentsResponse](docs/ListIssuedDocumentsResponse.md)
- [ListIssuedDocumentsResponsePage](docs/ListIssuedDocumentsResponsePage.md)
- [ListLanguagesResponse](docs/ListLanguagesResponse.md)
- [ListPaymentAccountsResponse](docs/ListPaymentAccountsResponse.md)
- [ListPaymentMethodsResponse](docs/ListPaymentMethodsResponse.md)
- [ListProductCategoriesResponse](docs/ListProductCategoriesResponse.md)
- [ListProductsResponse](docs/ListProductsResponse.md)
- [ListProductsResponsePage](docs/ListProductsResponsePage.md)
- [ListReceiptsResponse](docs/ListReceiptsResponse.md)
- [ListReceiptsResponsePage](docs/ListReceiptsResponsePage.md)
- [ListReceivedDocumentCategoriesResponse](docs/ListReceivedDocumentCategoriesResponse.md)
- [ListReceivedDocumentsResponse](docs/ListReceivedDocumentsResponse.md)
- [ListReceivedDocumentsResponsePage](docs/ListReceivedDocumentsResponsePage.md)
- [ListRevenueCentersResponse](docs/ListRevenueCentersResponse.md)
- [ListSuppliersResponse](docs/ListSuppliersResponse.md)
- [ListSuppliersResponsePage](docs/ListSuppliersResponsePage.md)
- [ListTemplatesResponse](docs/ListTemplatesResponse.md)
- [ListUnitsOfMeasureResponse](docs/ListUnitsOfMeasureResponse.md)
- [ListUserCompaniesResponse](docs/ListUserCompaniesResponse.md)
- [ListUserCompaniesResponseData](docs/ListUserCompaniesResponseData.md)
- [ListVatTypesResponse](docs/ListVatTypesResponse.md)
- [ListWebhooksSubscriptionsResponse](docs/ListWebhooksSubscriptionsResponse.md)
- [ModifyArchiveDocumentRequest](docs/ModifyArchiveDocumentRequest.md)
- [ModifyArchiveDocumentResponse](docs/ModifyArchiveDocumentResponse.md)
- [ModifyCashbookEntryRequest](docs/ModifyCashbookEntryRequest.md)
- [ModifyCashbookEntryResponse](docs/ModifyCashbookEntryResponse.md)
- [ModifyClientRequest](docs/ModifyClientRequest.md)
- [ModifyClientResponse](docs/ModifyClientResponse.md)
- [ModifyF24Request](docs/ModifyF24Request.md)
- [ModifyF24Response](docs/ModifyF24Response.md)
- [ModifyIssuedDocumentRequest](docs/ModifyIssuedDocumentRequest.md)
- [ModifyIssuedDocumentResponse](docs/ModifyIssuedDocumentResponse.md)
- [ModifyPaymentAccountRequest](docs/ModifyPaymentAccountRequest.md)
- [ModifyPaymentAccountResponse](docs/ModifyPaymentAccountResponse.md)
- [ModifyPaymentMethodRequest](docs/ModifyPaymentMethodRequest.md)
- [ModifyPaymentMethodResponse](docs/ModifyPaymentMethodResponse.md)
- [ModifyProductRequest](docs/ModifyProductRequest.md)
- [ModifyProductResponse](docs/ModifyProductResponse.md)
- [ModifyReceiptRequest](docs/ModifyReceiptRequest.md)
- [ModifyReceiptResponse](docs/ModifyReceiptResponse.md)
- [ModifyReceivedDocumentRequest](docs/ModifyReceivedDocumentRequest.md)
- [ModifyReceivedDocumentResponse](docs/ModifyReceivedDocumentResponse.md)
- [ModifySupplierRequest](docs/ModifySupplierRequest.md)
- [ModifySupplierResponse](docs/ModifySupplierResponse.md)
- [ModifyVatTypeRequest](docs/ModifyVatTypeRequest.md)
- [ModifyVatTypeResponse](docs/ModifyVatTypeResponse.md)
- [ModifyWebhooksSubscriptionRequest](docs/ModifyWebhooksSubscriptionRequest.md)
- [ModifyWebhooksSubscriptionResponse](docs/ModifyWebhooksSubscriptionResponse.md)
- [MonthlyTotal](docs/MonthlyTotal.md)
- [OriginalDocumentType](docs/OriginalDocumentType.md)
- [Pagination](docs/Pagination.md)
- [PaymentAccount](docs/PaymentAccount.md)
- [PaymentAccountType](docs/PaymentAccountType.md)
- [PaymentMethod](docs/PaymentMethod.md)
- [PaymentMethodDetails](docs/PaymentMethodDetails.md)
- [PaymentMethodType](docs/PaymentMethodType.md)
- [PaymentTermsType](docs/PaymentTermsType.md)
- [PermissionLevel](docs/PermissionLevel.md)
- [Permissions](docs/Permissions.md)
- [PermissionsFicIssuedDocumentsDetailed](docs/PermissionsFicIssuedDocumentsDetailed.md)
- [Product](docs/Product.md)
- [Receipt](docs/Receipt.md)
- [ReceiptItemsListItem](docs/ReceiptItemsListItem.md)
- [ReceiptPreCreateInfo](docs/ReceiptPreCreateInfo.md)
- [ReceiptType](docs/ReceiptType.md)
- [ReceivedDocument](docs/ReceivedDocument.md)
- [ReceivedDocumentInfo](docs/ReceivedDocumentInfo.md)
- [ReceivedDocumentInfoDefaultValues](docs/ReceivedDocumentInfoDefaultValues.md)
- [ReceivedDocumentInfoItemsDefaultValues](docs/ReceivedDocumentInfoItemsDefaultValues.md)
- [ReceivedDocumentItemsListItem](docs/ReceivedDocumentItemsListItem.md)
- [ReceivedDocumentPaymentsListItem](docs/ReceivedDocumentPaymentsListItem.md)
- [ReceivedDocumentPaymentsListItemPaymentTerms](docs/ReceivedDocumentPaymentsListItemPaymentTerms.md)
- [ReceivedDocumentTotals](docs/ReceivedDocumentTotals.md)
- [ReceivedDocumentType](docs/ReceivedDocumentType.md)
- [ScheduleEmailRequest](docs/ScheduleEmailRequest.md)
- [SendEInvoiceRequest](docs/SendEInvoiceRequest.md)
- [SendEInvoiceRequestData](docs/SendEInvoiceRequestData.md)
- [SendEInvoiceRequestOptions](docs/SendEInvoiceRequestOptions.md)
- [SendEInvoiceResponse](docs/SendEInvoiceResponse.md)
- [SendEInvoiceResponseData](docs/SendEInvoiceResponseData.md)
- [SenderEmail](docs/SenderEmail.md)
- [ShowTotalsMode](docs/ShowTotalsMode.md)
- [Supplier](docs/Supplier.md)
- [SupplierType](docs/SupplierType.md)
- [TransformIssuedDocumentResponse](docs/TransformIssuedDocumentResponse.md)
- [UploadArchiveAttachmentResponse](docs/UploadArchiveAttachmentResponse.md)
- [UploadF24AttachmentResponse](docs/UploadF24AttachmentResponse.md)
- [UploadIssuedDocumentAttachmentResponse](docs/UploadIssuedDocumentAttachmentResponse.md)
- [UploadReceivedDocumentAttachmentResponse](docs/UploadReceivedDocumentAttachmentResponse.md)
- [User](docs/User.md)
- [UserCompanyRole](docs/UserCompanyRole.md)
- [VatItem](docs/VatItem.md)
- [VatKind](docs/VatKind.md)
- [VatType](docs/VatType.md)
- [VerifyEInvoiceXmlErrorResponse](docs/VerifyEInvoiceXmlErrorResponse.md)
- [VerifyEInvoiceXmlErrorResponseError](docs/VerifyEInvoiceXmlErrorResponseError.md)
- [VerifyEInvoiceXmlErrorResponseErrorValidationResult](docs/VerifyEInvoiceXmlErrorResponseErrorValidationResult.md)
- [VerifyEInvoiceXmlErrorResponseExtra](docs/VerifyEInvoiceXmlErrorResponseExtra.md)
- [VerifyEInvoiceXmlResponse](docs/VerifyEInvoiceXmlResponse.md)
- [VerifyEInvoiceXmlResponseData](docs/VerifyEInvoiceXmlResponseData.md)
- [WebhooksSubscription](docs/WebhooksSubscription.md)
- [WebhooksSubscriptionConfig](docs/WebhooksSubscriptionConfig.md)
- [WebhooksSubscriptionMapping](docs/WebhooksSubscriptionMapping.md)

<a id="documentation-for-authorization"></a>

## Documentation For Authorization

Authentication schemes defined for the API:
<a id="OAuth2AuthenticationCodeFlow"></a>

### OAuth2AuthenticationCodeFlow

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://api-v2.fattureincloud.it/oauth/authorize
- **Scopes**:
- **entity.clients:r**: Read permission to the Clients registry
- **entity.clients:a**: Write permission to the Clients registry
- **entity.suppliers:r**: Read permission to the Suppliers registry
- **entity.suppliers:a**: Write permission to the Suppliers registry
- **products:r**: Read permission to the Products
- **products:a**: Write permission to the Products
- **issued_documents.invoices:r**: Read permission to the issued Invoices
- **issued_documents.credit_notes:r**: Read permission to the issued Credit Notes
- **issued_documents.receipts:r**: Read permission to the issued Receipts
- **issued_documents.orders:r**: Read permission to the issued Orders
- **issued_documents.quotes:r**: Read permission to the issued Quotes
- **issued_documents.proformas:r**: Read permission to the issued Proformas
- **issued_documents.delivery_notes:r**: Read permission to the issued Delivery Notes
- **issued_documents.work_reports:r**: Read permission to the issued Work Reports
- **issued_documents.supplier_orders:r**: Read permission to the issued Supplier Orders
- **issued_documents.self_invoices:r**: Read permission to the issued Self Invoices
- **issued_documents.invoices:a**: Write permission to the issued Invoices
- **issued_documents.credit_notes:a**: Write permission to the issued Credit Notes
- **issued_documents.receipts:a**: Write permission to the issued issued Receipts
- **issued_documents.orders:a**: Write permission to the issued Orders
- **issued_documents.quotes:a**: Write permission to the issued Quotes
- **issued_documents.proformas:a**: Write permission to the issued Proformas
- **issued_documents.delivery_notes:a**: Write permission to the issued Delivery Notes
- **issued_documents.work_reports:a**: Write permission to the issued Work Reports
- **issued_documents.supplier_orders:a**: Write permission to the issued Supplier Orders
- **issued_documents.self_invoices:a**: Write permission to the issued Self Invoices
- **received_documents:r**: Read permission to the Received Documents
- **received_documents:a**: Write permission to the Received Documents
- **stock:r**: Read permission to the Stock movements
- **stock:a**: Write permission to the Stock movements
- **receipts:r**: Read permission to the Receipts
- **receipts:a**: Write permission to the Receipts
- **taxes:r**: Read permission to the Taxes
- **taxes:a**: Write permission to the Taxes
- **archive:r**: Read permission to the Archive Documents
- **archive:a**: Read permission to the Archive Documents
- **cashbook:r**: Read permission to the Cashbook
- **cashbook:a**: Write permission to the Cashbook
- **settings:r**: Read permission to the Settings
- **settings:a**: Write permission to the Settings
- **situation:r**: Read permission to the company Situation

## Author

info@fattureincloud.it
